% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-stepaic-forward-regression.R
\name{ols_stepaic_forward}
\alias{ols_stepaic_forward}
\alias{plot.ols_stepaic_forward}
\title{Stepwise AIC Forward Regression}
\usage{
ols_stepaic_forward(model, ...)

\method{plot}{ols_stepaic_forward}(x, ...)
}
\arguments{
\item{model}{an object of class \code{lm}}

\item{...}{other arguments}

\item{x}{an object of class \code{ols_stepaic_forward}}
}
\value{
\code{ols_stepaic_forward} returns an object of class \code{"ols_stepaic_forward"}.
An object of class \code{"ols_stepaic_forward"} is a list containing the
following components:

\item{steps}{f statistic}
\item{predictors}{p value of \code{score}}
\item{aics}{degrees of freedom}
\item{ess}{fitted values of the regression model}
\item{rss}{name of explanatory variables of fitted regression model}
\item{rsq}{response variable}
\item{arsq}{predictors}
}
\description{
Build regression model from a set of candidate predictor variables by entering predictors based on 
Akaike Information Criteria, in a stepwise manner until there is no variable left to enter any more.
}
\examples{
# stepwise forward regression
model <- lm(y ~ ., data = surgical)
ols_stepaic_forward(model)

# stepwise forward regression plot
model <- lm(y ~ ., data = surgical)
k <- ols_stepaic_forward(model)
plot(k)

}
\references{
Venables, W. N. and Ripley, B. D. (2002) Modern Applied Statistics with S. Fourth edition. Springer.
}

