% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-best-subsets-regression.R
\name{ols_best_subset}
\alias{ols_best_subset}
\alias{plot.ols_best_subset}
\title{Best Subsets Regression}
\usage{
ols_best_subset(model, ...)

\method{plot}{ols_best_subset}(x, model = NA, ...)
}
\arguments{
\item{model}{an object of class \code{lm}}

\item{...}{other inputs}

\item{x}{an object of class \code{ols_best_subset}}
}
\value{
\code{ols_best_subset} returns an object of class \code{"ols_best_subset"}.
An object of class \code{"ols_best_subset"} is a data frame containing the
following components:

\item{n}{model number}
\item{predictors}{predictors in the model}
\item{rsquare}{rsquare of the model}
\item{adjr}{adjusted rsquare of the model}
\item{predrsq}{predicted rsquare of the model}
\item{cp}{Mallow's Cp}
\item{aic}{Akaike Information Criteria}
\item{sbic}{Sawa Bayesian Information Criteria}
\item{sbc}{Schwarz Bayes Information Criteria}
\item{gmsep}{estimated MSE of prediction, assuming multivariate normality}
\item{jp}{final prediction error}
\item{pc}{Amemiya Prediction Criteria}
\item{sp}{Hocking's Sp}
}
\description{
Select the subset of predictors that do the best at meeting some
well-defined objective criterion, such as having the largest R2 value or the
smallest MSE, Mallow's Cp or AIC.
}
\examples{
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
ols_best_subset(model)

# plot
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
k <- ols_best_subset(model)
plot(k)
}
\references{
Kutner, MH, Nachtscheim CJ, Neter J and Li W., 2004, Applied Linear Statistical Models (5th edition). 
Chicago, IL., McGraw Hill/Irwin.
}

