% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph_location.R
\name{fortify_location}
\alias{fortify_location}
\title{Eval a location on the current slide}
\usage{
fortify_location(x, doc, ...)
}
\arguments{
\item{x}{a location for a placeholder.}

\item{doc}{an rpptx object}

\item{...}{unused arguments}
}
\description{
Eval a shape location against the current slide.
This function is to be used to add custom openxml code. A
list is returned, it contains informations width, height, left
and top positions and other informations necessary to add a
content on a slide.
}
\examples{
doc <- read_pptx()
doc <- add_slide(doc, layout = "Title and Content",
  master = "Office Theme")
fortify_location(ph_location_fullsize(), doc)
}
\seealso{
\code{\link{ph_location}}, \code{\link{ph_with}}

Other functions for officer extensions: 
\code{\link{docx_reference_img}()},
\code{\link{get_reference_value}()},
\code{\link{opts_current_table}()},
\code{\link{to_html}()},
\code{\link{to_pml}()},
\code{\link{to_wml}()},
\code{\link{wml_link_images}()}
}
\concept{functions for officer extensions}
\keyword{internal}
