% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting_properties.R
\name{fp_par}
\alias{fp_par}
\alias{print.fp_par}
\alias{update.fp_par}
\title{Paragraph formatting properties}
\usage{
fp_par(
  text.align = "left",
  padding = 0,
  line_spacing = 1,
  border = fp_border(width = 0),
  padding.bottom,
  padding.top,
  padding.left,
  padding.right,
  border.bottom,
  border.left,
  border.top,
  border.right,
  shading.color = "transparent",
  keep_with_next = FALSE
)

\method{print}{fp_par}(x, ...)

\method{update}{fp_par}(
  object,
  text.align,
  padding,
  border,
  padding.bottom,
  padding.top,
  padding.left,
  padding.right,
  border.bottom,
  border.left,
  border.top,
  border.right,
  shading.color,
  ...
)
}
\arguments{
\item{text.align}{text alignment - a single character value, expected value
is one of 'left', 'right', 'center', 'justify'.}

\item{padding}{paragraph paddings - 0 or positive integer value. Argument \code{padding} overwrites
arguments \code{padding.bottom}, \code{padding.top}, \code{padding.left}, \code{padding.right}.}

\item{line_spacing}{line spacing, 1 is single line spacing, 2 is double line spacing.}

\item{border}{shortcut for all borders.}

\item{padding.bottom, padding.top, padding.left, padding.right}{paragraph paddings - 0 or positive integer value.}

\item{border.bottom, border.left, border.top, border.right}{\code{\link{fp_border}} for
borders. overwrite other border properties.}

\item{shading.color}{shading color - a single character value specifying
a valid color (e.g. "#000000" or "black").}

\item{keep_with_next}{a scalar logical. Specifies that the paragraph (or at least part of it) should be rendered
on the same page as the next paragraph when possible.}

\item{x, object}{\code{fp_par} object}

\item{...}{further arguments - not used}
}
\value{
a \code{fp_par} object
}
\description{
Create a \code{fp_par} object that describes
paragraph formatting properties.
}
\examples{
fp_par(text.align = "center", padding = 5)
obj <- fp_par(text.align = "center", padding = 1)
update( obj, padding.bottom = 5 )
}
\seealso{
\link{fpar}

Other functions for defining formatting properties: 
\code{\link{fp_border}()},
\code{\link{fp_cell}()},
\code{\link{fp_text}()}
}
\concept{functions for defining formatting properties}
