% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppt_ph_add.R
\name{ph_add_fpar}
\alias{ph_add_fpar}
\title{append fpar}
\usage{
ph_add_fpar(x, value, type = "body", id_chr = NULL, level = 1)
}
\arguments{
\item{x}{a pptx device}

\item{value}{fpar object}

\item{type}{placeholder type}

\item{id_chr}{placeholder id (a string). This is to be used when a placeholder type
is not unique in the current slide, e.g. two placeholders with type 'body'.
Values can be read from \code{\link{slide_summary}}.}

\item{level}{paragraph level}
}
\description{
append \code{fpar} (a formatted paragraph) in a placeholder
}
\examples{
library(magrittr)

bold_face <- shortcuts$fp_bold(font.size = 30)
bold_redface <- update(bold_face, color = "red")

fpar_ <- fpar(ftext("Hello ", prop = bold_face),
  ftext("World", prop = bold_redface ),
  ftext(", how are you?", prop = bold_face ) )

doc <- read_pptx() \%>\%
  add_slide(layout = "Title and Content", master = "Office Theme") \%>\%
  ph_empty(type = "body") \%>\%
  ph_add_fpar(value = fpar_, type = "body", level = 2)

if( has_zip() )
  print(doc, target = "ph_add_fpar.pptx")
}
\seealso{
\code{\link{fpar}}
}
