% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storage.R
\name{Storage}
\alias{Storage}
\title{Storage R6 Object}
\value{
The output depends on the method:
\itemize{
\item \code{$new()} returns a \code{Storage} object.
\item \code{$add()}, \code{$remove()}, and \code{$print()} invisibly return the
\code{Storage} object (to allow for method chaining)
\item \code{$get()} returns the requested element(s)
\item \code{$number()} returns an \code{integer}
\item \code{$indices()} return an \code{integer} \code{vector}
}
}
\description{
Provides a simple indexing interface for list elements based on R6.
Basically, it allows to store items in a list and to regain them based on
identifiers defined by the user.
}
\section{Setting identifiers}{

An identifier is a \code{character}, typically a binary property. Identifiers
can be negated by placing an exclamation mark (\code{"!"}) in front of them.
Identifiers that have been assigned to other elements previously do not need
to be specified again for new elements; instead, a default value can be used.
This default value can be defined either globally for all cases (via the
\code{$missing_identifier} field) or separately for each specific case (via
the method argument).
}

\section{User confirmation}{

If desired, the user can be asked for confirmation when adding, extracting,
or removing elements using identifiers. This behavior can be set globally
through the \code{$confirm} field or customized separately for each specific
case via the method argument.
}

\examples{
### 1. Create a `Storage` object:
my_storage <- Storage$new()

# 2. Add elements along with identifiers:
my_storage$
  add(42, c("number", "rational"))$
  add(pi, c("number", "!rational"))$
  add("fear of black cats", c("text", "!rational"))$
  add("wearing a seat belt", c("text", "rational"))$
  add(mean, "function")

# 3. What elements are stored?
print(my_storage)

# 4. Extract elements based on identifiers:
my_storage$get("rational")
my_storage$get("!rational")
my_storage$get(c("text", "!rational"))
my_storage$get("all") # get all elements
my_storage$get(c("text", "!text"))
my_storage$get(c("text", "!text"), logical = "or")

# 5. Extract elements based on ids:
my_storage$get(ids = 4:5)
my_storage$get(ids = 4:5, id_names = TRUE) # add the ids as names
}
\seealso{
Other package helpers: 
\code{\link{Dictionary}},
\code{\link{identical_structure}()},
\code{\link{input_check_response}()},
\code{\link{match_arg}()},
\code{\link{package_logo}()},
\code{\link{print_data.frame}()},
\code{\link{print_matrix}()},
\code{\link{system_information}()},
\code{\link{unexpected_error}()},
\code{\link{user_confirm}()}
}
\concept{package helpers}
\keyword{indexing}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{identifier}}{[\code{character()}]\cr
The identifiers used.}

\item{\code{confirm}}{[\code{logical(1)}]\cr
The default value for confirmations.}

\item{\code{missing_identifier}}{[\code{logical(1)}]\cr
The default value for not specified identifiers.}

\item{\code{hide_warnings}}{[\code{logical(1)}]\cr
Hide warnings (for example if unknown identifiers are selected)?}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Storage-new}{\code{Storage$new()}}
\item \href{#method-Storage-add}{\code{Storage$add()}}
\item \href{#method-Storage-get}{\code{Storage$get()}}
\item \href{#method-Storage-remove}{\code{Storage$remove()}}
\item \href{#method-Storage-number}{\code{Storage$number()}}
\item \href{#method-Storage-indices}{\code{Storage$indices()}}
\item \href{#method-Storage-print}{\code{Storage$print()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Storage-new"></a>}}
\if{latex}{\out{\hypertarget{method-Storage-new}{}}}
\subsection{Method \code{new()}}{
Initializing a \code{Storage} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Storage$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Storage-add"></a>}}
\if{latex}{\out{\hypertarget{method-Storage-add}{}}}
\subsection{Method \code{add()}}{
Adding an element.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Storage$add(
  x,
  identifier,
  confirm = interactive() & self$confirm,
  missing_identifier = self$missing_identifier
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{[\code{any()}]\cr
An object to be saved.}

\item{\code{identifier}}{[\code{character()}]\cr
Pne or more identifiers (the identifier \code{"all"} is reserved to select
all elements).}

\item{\code{confirm}}{[\code{logical(1)}]\cr
Prompted for confirmation?}

\item{\code{missing_identifier}}{[\code{logical(1)} | NA]\cr
The value for not specified identifiers.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Storage-get"></a>}}
\if{latex}{\out{\hypertarget{method-Storage-get}{}}}
\subsection{Method \code{get()}}{
Getting elements.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Storage$get(
  identifier = character(),
  ids = integer(),
  logical = "and",
  confirm = interactive() & self$confirm,
  missing_identifier = self$missing_identifier,
  id_names = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identifier}}{[\code{character()}]\cr
Pne or more identifiers (the identifier \code{"all"} is reserved to select
all elements).}

\item{\code{ids}}{[\code{integer()}]\cr
One or more ids.}

\item{\code{logical}}{[\code{character(1)}]\cr
In the case that multiple identifiers are selected, how should they be
combined? Options are:
\itemize{
\item \code{"and"} (the default): the identifiers are combined with logical and
(all identifiers must be \code{TRUE})
\item \code{"or"}: the identifiers are combined with logical or (at least one
identifier must be \code{TRUE})
}}

\item{\code{confirm}}{[\code{logical(1)}]\cr
Prompted for confirmation?}

\item{\code{missing_identifier}}{[\code{logical(1)} | NA]\cr
The value for not specified identifiers.}

\item{\code{id_names}}{[\code{logical(1)}]\cr
Name the elements according to their ids?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Storage-remove"></a>}}
\if{latex}{\out{\hypertarget{method-Storage-remove}{}}}
\subsection{Method \code{remove()}}{
removing elements
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Storage$remove(
  identifier = character(),
  ids = integer(),
  logical = "and",
  confirm = interactive() & self$confirm,
  missing_identifier = self$missing_identifier,
  shift_ids = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identifier}}{[\code{character()}]\cr
Pne or more identifiers (the identifier \code{"all"} is reserved to select
all elements).}

\item{\code{ids}}{[\code{integer()}]\cr
One or more ids.}

\item{\code{logical}}{[\code{character(1)}]\cr
In the case that multiple identifiers are selected, how should they be
combined? Options are:
\itemize{
\item \code{"and"} (the default): the identifiers are combined with logical and
(all identifiers must be \code{TRUE})
\item \code{"or"}: the identifiers are combined with logical or (at least one
identifier must be \code{TRUE})
}}

\item{\code{confirm}}{[\code{logical(1)}]\cr
Prompted for confirmation?}

\item{\code{missing_identifier}}{[\code{logical(1)} | NA]\cr
The value for not specified identifiers.}

\item{\code{shift_ids}}{[\code{logical(1)}]\cr
Shift ids when in-between elements are removed?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Storage-number"></a>}}
\if{latex}{\out{\hypertarget{method-Storage-number}{}}}
\subsection{Method \code{number()}}{
Computing the number of identified elements.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Storage$number(
  identifier = "all",
  missing_identifier = self$missing_identifier,
  logical = "and",
  confirm = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identifier}}{[\code{character()}]\cr
Pne or more identifiers (the identifier \code{"all"} is reserved to select
all elements).}

\item{\code{missing_identifier}}{[\code{logical(1)} | NA]\cr
The value for not specified identifiers.}

\item{\code{logical}}{[\code{character(1)}]\cr
In the case that multiple identifiers are selected, how should they be
combined? Options are:
\itemize{
\item \code{"and"} (the default): the identifiers are combined with logical and
(all identifiers must be \code{TRUE})
\item \code{"or"}: the identifiers are combined with logical or (at least one
identifier must be \code{TRUE})
}}

\item{\code{confirm}}{[\code{logical(1)}]\cr
Prompted for confirmation?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Storage-indices"></a>}}
\if{latex}{\out{\hypertarget{method-Storage-indices}{}}}
\subsection{Method \code{indices()}}{
Returning indices based on defined identifiers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Storage$indices(
  identifier = "all",
  logical = "and",
  confirm = interactive() & self$confirm
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identifier}}{[\code{character()}]\cr
Pne or more identifiers (the identifier \code{"all"} is reserved to select
all elements).}

\item{\code{logical}}{[\code{character(1)}]\cr
In the case that multiple identifiers are selected, how should they be
combined? Options are:
\itemize{
\item \code{"and"} (the default): the identifiers are combined with logical and
(all identifiers must be \code{TRUE})
\item \code{"or"}: the identifiers are combined with logical or (at least one
identifier must be \code{TRUE})
}}

\item{\code{confirm}}{[\code{logical(1)}]\cr
Prompted for confirmation?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Storage-print"></a>}}
\if{latex}{\out{\hypertarget{method-Storage-print}{}}}
\subsection{Method \code{print()}}{
Printing details of the saved elements.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Storage$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Currently not used.}
}
\if{html}{\out{</div>}}
}
}
}
