% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_matrix.R
\name{print_matrix}
\alias{print_matrix}
\title{Print (abbreviated) \code{matrix}}
\usage{
print_matrix(
  x,
  rowdots = 4,
  coldots = 4,
  digits = 2,
  label = NULL,
  simplify = FALSE,
  details = !simplify
)
}
\arguments{
\item{x}{A \code{numeric} or \code{character} (\code{vector} or \code{matrix}).}

\item{rowdots}{An \code{integer}, the row number which is replaced by \code{...}.
By default, \code{rowdots = 4}.}

\item{coldots}{An \code{integer}, the column number which is replaced by \code{...}.
By default, \code{coldots = 4}.}

\item{digits}{An \code{integer}, the number of printed decimal places.
Only relevant if input \code{x} is numeric.
By default, \code{digits = 2}.}

\item{label}{A \code{character}, a label for \code{x}.
Only printed if \code{simplify = FALSE}.
By default, \code{label = NULL}, i.e., no label.}

\item{simplify}{A \code{logical}, set to \code{TRUE} to simplify the output.
By default, \code{simplify = FALSE}.}

\item{details}{A \code{logical}, set to \code{TRUE} to print the type and
dimension of \code{x}.
By default, \code{details = !simplify}.}
}
\value{
Invisibly returns \code{x}.
}
\description{
This function prints a (possibly abbreviated) \code{matrix}.
}
\examples{
print_matrix(x = 1, label = "single numeric")
print_matrix(x = LETTERS[1:26], label = "letters")
print_matrix(x = 1:3, coldots = 2)
print_matrix(x = matrix(rnorm(99), ncol = 1), label = "single column matrix")
print_matrix(x = matrix(1:100, nrow = 1), label = "single row matrix")
print_matrix(x = matrix(LETTERS[1:24], ncol = 6), label = "big matrix")
print_matrix(x = diag(5), coldots = 2, rowdots = 2, simplify = TRUE)

}
\references{
This function is a modified version of \code{ramify::pprint()}.
}
