% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_transition_probability_matrix.R
\name{check_transition_probability_matrix}
\alias{check_transition_probability_matrix}
\alias{assert_transition_probability_matrix}
\alias{test_transition_probability_matrix}
\title{Check if an argument is a transition probability matrix}
\usage{
check_transition_probability_matrix(
  x,
  dim = NULL,
  tolerance = sqrt(.Machine$double.eps)
)

assert_transition_probability_matrix(
  x,
  dim = NULL,
  tolerance = sqrt(.Machine$double.eps),
  .var.name = checkmate::vname(x),
  add = NULL
)

test_transition_probability_matrix(
  x,
  dim = NULL,
  tolerance = sqrt(.Machine$double.eps)
)
}
\arguments{
\item{x}{Object to check.}

\item{dim}{An \code{integer}, the matrix dimension.}

\item{tolerance}{A non-negative \code{numeric} tolerance value.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link[checkmate]{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link[checkmate]{AssertCollection}}.}
}
\value{
Compare to \code{\link[checkmate]{check_matrix}}.
}
\description{
This function checks whether the input is a quadratic, real matrix with
elements between 0 and 1 and row sums equal to 1.
}
