% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cholesky_root.R
\name{cov_2_chol}
\alias{cov_2_chol}
\alias{chol_2_cov}
\title{Get Cholesky root elements and build covariance matrix}
\usage{
cov_2_chol(cov, unique = TRUE)

chol_2_cov(chol)
}
\arguments{
\item{cov}{A covariance \code{matrix} of dimension \code{dim}.}

\item{unique}{Set to \code{TRUE} to ensure that the Cholesky decomposition is unique
by restricting the diagonal elements to be positive.}

\item{chol}{A \code{numeric} \code{vector} of Cholesky root elements.}
}
\value{
For \code{\link{cov_2_chol}} a \code{numeric} \code{vector} of Cholesky root
elements.
For \code{\link{chol_2_cov}} a covariance \code{matrix}.
}
\description{
These functions compute the Cholesky root elements of a covariance matrix
and, conversely, build a covariance matrix from its Cholesky root elements.
}
\examples{
cov <- sample_covariance_matrix(4)
chol <- cov_2_chol(cov)
all.equal(cov, chol_2_cov(chol))

}
