% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odin_options.R
\name{odin_options}
\alias{odin_options}
\title{Odin options}
\usage{
odin_options(verbose = NULL, target = NULL, workdir = NULL,
  validate = NULL, pretty = NULL, skip_cache = NULL,
  compiler_warnings = NULL, no_check_unused_equations = NULL,
  no_check_naked_index = NULL, options = NULL)
}
\arguments{
\item{verbose}{Logical scalar indicating if the compilation should
be verbose.  Defaults to the value of the option
\code{odin.verbose} or \code{FALSE} otherwise.}

\item{target}{Compilation target.  Options are "c" and "r",
defaulting to the option \code{odin.target} or "c" otherwise.}

\item{workdir}{Directory to use for any generated files.  This is
only relevant for the "c" target.  Defaults to the value of the
option \code{odin.workdir} or \code{tempdir()} otherwise.}

\item{validate}{Validate the model's intermediate representation
against the included schema.  Normally this is not needed and is
intended primarily for development use.  Defaults to the value
of the option \code{odin.validate} or \code{FALSE} otherwise.}

\item{pretty}{Pretty-print the model's intermediate
representation.  Normally this is not needed and is intended
primarily for development use.  Defaults to the value of the
option \code{odin.pretty} or \code{FALSE} otherwise.}

\item{skip_cache}{Skip odin's cache.  This might be useful if the
model appears not to compile when you would expect it to.
Hopefully this will not be needed often.  Defaults to the option
\code{odin.skip_cache} or \code{FALSE} otherwise.}

\item{compiler_warnings}{Logical scalar indicating if compiler
warnings should be converted to R warnings.  If this is
\code{TRUE}, then if any compiler warnings are generated, the
compiler output will be displayed (regardless of the value of
\code{verbose}) within an R warning (suppressible via
\code{suppressWarnings} and catchable via \code{tryCatch}).  The
default is to default to \code{FALSE} unless the global option
\code{odin.compiler_warnings} is set to \code{TRUE} (set with
\code{options(odin.compiler_warnings = TRUE)}).  The default may
change to \code{TRUE} in future.  Warnings are currently a mix
of ambiguous syntax in your model (worth fixing) and limitations
in the code that odin generates (which you can't fix but I will
get on to over time).  What is flagged will depend strongly on
your platform and what is in your \code{Makevars}.  I develop
odin with \code{-Wall -Wextra -pedantic} and still see warnings
with both gcc and clang.  The compiler output is very simple and
may not work on all platforms.  Defaults to the option
\code{odin.compiler_warnings} or \code{FALSE} otherwise.}

\item{no_check_unused_equations}{If \code{TRUE}, then don't print
messages about unused variables.  Defaults to the option
\code{odin.no_check_unused_equations} or \code{FALSE} otherwise.}

\item{no_check_naked_index}{If \code{TRUE}, then if an index
variable (\code{i}, \code{j}, ...) is used outside of an array
subset (e.g., \code{x[] <- i}) then a notice is printed.  The
behaviour of this functionality changed in odin version
\code{0.2.0} and this flag is intended to notify users about the
change.  See \url{https://github.com/mrc-ide/odin/issues/136}
for more information.  Defaults to the option
\code{odin.no_check_naked_index} or \code{FALSE} otherwise.}

\item{options}{Named list of options.  If provided, then all other
options are ignored.}
}
\description{
For lower-level odin functions \code{\link{odin_parse}},
\code{\link{odin_validate}} we accept a list of options rather
than individually named options.
}
\examples{
odin_options()
}
