% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/section.R
\name{handleFlags,section-method}
\alias{handleFlags,section-method}
\alias{handleFlags.section}
\title{Handle flags in Section Objects}
\usage{
\S4method{handleFlags}{section}(
  object = "oce",
  flags = NULL,
  actions = NULL,
  where = where,
  debug = getOption("oceDebug")
)
}
\arguments{
\item{object}{A \linkS4class{section} object.}

\item{flags}{A \link{list} specifying flag values upon which
actions will be taken. This can take two forms.
\itemize{
\item In the first form, the
list has named elements each containing a vector of integers. For example,
salinities flagged with values of 1 or 3:9 would be specified
by \code{flags=list(salinity=c(1,3:9))}. Several data items can be specified,
e.g. \code{flags=list(salinity=c(1,3:9), temperature=c(1,3:9))} indicates
that the actions are to take place for both salinity and temperature.
\item In the second form, \code{flags} is a list holding a single \emph{unnamed} vector, and
this means to apply the actions to \emph{all} the data entries.  For example,
\code{flags=list(c(1,3:9))} means to apply not just to salinity and temperature,
but to everything within the \code{data} slot.
}

If \code{flags} is not provided, then \code{\link[=defaultFlags]{defaultFlags()}} is called, to try to
determine a reasonable default.}

\item{actions}{an optional \link{list} that contains items with
names that match those in the \code{flags} argument.  If \code{actions}
is not supplied, the default will be to set all values identified by
\code{flags} to \code{NA}; this can also be specified by
specifying \code{actions=list("NA")}. It is also possible to specify
functions that calculate replacement values. These are provided
with \code{object} as the single argument, and must return a
replacement for the data item in question.
See \dQuote{Details} for the default that is used if \code{actions} is not supplied.}

\item{where}{an optional character value that permits the function to work with
objects that store flags in e.g. \code{object@metadata$flags$where}
instead of in \code{object@metadata$flags}, and data within
\code{object@data$where} instead of within \code{object@data}. The
default value of \code{NULL} means to look withing \code{object@metadata}
itself, and this is the default within \code{oce}.  (The purpose of \code{where}
is to make \code{oce} extensible by other packages, which may choose to store
data two levels deep in the \code{data} slot.)}

\item{debug}{An optional integer specifying the degree of debugging, with
value 0 meaning to skip debugging and 1 or higher meaning to print some
information about the arguments and the data. It is usually a good idea to set
this to 1 for initial work with a dataset, to see which flags are being
handled for each data item. If not supplied, this defaults to the value of
\code{\link{getOption}}\code{("oceDebug")}.}
}
\description{
Data-quality flags are stored in the \code{metadata}
slot of \linkS4class{oce} objects in a
\link{list} named \code{flags}.
The present function (a generic that has specialized versions
for various data classes) provides a way to
manipulate the contents of the \code{data} slot, based on
such data-quality flags. For example, a common operation is to replace
erroneous data with \code{NA}.

If the \code{flags} within \code{object}'s \code{metadata} slot is empty,
then \code{object} is returned, unaltered.
Otherwise, \code{handleFlags} examines \code{object@metadata$flags}
in the context of the \code{flags} argument, and then
carries out actions that are specified by the \code{actions} argument.
By default, this sets the returned \code{data} entries to \code{NA},
wherever the corresponding \code{metadata$flag} values
signal unreliable data. To maintain a hint as to why
\code{data} were changed, \code{metadata$flags} in the
returned value is a direct copy of the corresponding
entry in \code{object}.
}
\details{
The default for \code{flags} is based on
calling \code{\link[=defaultFlags]{defaultFlags()}} based on the
\code{metadata} in the first station in the section. If the
other stations have different flag schemes (which seems highly
unlikely for archived data), this will not work well, and indeed
the only way to proceed would be to use \code{\link[=handleFlags,ctd-method]{handleFlags,ctd-method()}}
on the stations, individually.
}
\examples{
library(oce)
data(section)
section2 <- handleFlags(section, flags=c(1,3:9))
par(mfrow=c(2, 1))
plotTS(section)
plotTS(section2)

}
\references{
The following link used to work, but was found to fail in December 2020.
\enumerate{
\item \verb{https://www.nodc.noaa.gov/woce/woce_v3/wocedata_1/whp/exchange/exchange_format_desc.htm}
}
}
\seealso{
Other functions relating to data-quality flags: 
\code{\link{defaultFlags}()},
\code{\link{handleFlags,adp-method}},
\code{\link{handleFlags,argo-method}},
\code{\link{handleFlags,ctd-method}},
\code{\link{handleFlags,oce-method}},
\code{\link{handleFlags}()},
\code{\link{initializeFlagScheme,ctd-method}},
\code{\link{initializeFlagScheme,oce-method}},
\code{\link{initializeFlagScheme,section-method}},
\code{\link{initializeFlagSchemeInternal}()},
\code{\link{initializeFlagScheme}()},
\code{\link{initializeFlags,adp-method}},
\code{\link{initializeFlags,oce-method}},
\code{\link{initializeFlagsInternal}()},
\code{\link{initializeFlags}()},
\code{\link{setFlags,adp-method}},
\code{\link{setFlags,ctd-method}},
\code{\link{setFlags,oce-method}},
\code{\link{setFlags}()}

Other things related to section data: 
\code{\link{[[,section-method}},
\code{\link{[[<-,section-method}},
\code{\link{as.section}()},
\code{\link{initializeFlagScheme,section-method}},
\code{\link{plot,section-method}},
\code{\link{read.section}()},
\code{\link{section-class}},
\code{\link{sectionAddStation}()},
\code{\link{sectionGrid}()},
\code{\link{sectionSmooth}()},
\code{\link{sectionSort}()},
\code{\link{section}},
\code{\link{subset,section-method}},
\code{\link{summary,section-method}}
}
\concept{functions relating to data-quality flags}
\concept{things related to section data}
