% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsk.R
\name{read.rsk}
\alias{read.rsk}
\title{Read a Rsk file}
\usage{
read.rsk(
  file,
  from = 1,
  to,
  by = 1,
  type,
  encoding = NA,
  tz = getOption("oceTz", default = "UTC"),
  tzOffsetLocation,
  patm = FALSE,
  allTables = TRUE,
  processingLog,
  debug = getOption("oceDebug")
)
}
\arguments{
\item{file}{a connection or a character string giving the name of the RSK file to
load. Note that \code{file} must be a character string, because connections are
not used in that case, which is instead handled with database calls.}

\item{from}{indication of the first datum to read.  This can a positive integer
to indicate sequence number, the POSIX time of the first datum, or a character
string that can be converted to a POSIX time.  (For POSIX times, be careful
about the \code{tz} argument.)}

\item{to}{an indication of the last datum to be read, in the same format as
\code{from}.  If \code{to} is missing, data will be read to the end of the file.}

\item{by}{an indication of the stride length to use while walking through the
file.  If this is an integer, then \code{by-1} samples are skipped between each
pair of samples that is read.  If this is a string representing a time interval,
in colon-separated format (HH:MM:SS or MM:SS), then this interval is divided by
the sampling interval, to get the stride length.}

\item{type}{optional file type, presently can be \code{rsk} or \code{txt} (for a
text export of an RBR rsk or hex file). If this argument is not provided, an
attempt will be made to infer the type from the file name and contents.}

\item{encoding}{ignored.}

\item{tz}{time zone.  The value \code{oceTz} is set at package setup.}

\item{tzOffsetLocation}{offset, in hours, between the CTD clock and
the clock in the controlling computer/tablet/phone (if one was used during
the sampling). This offset is required to relate location information from the
controller to hydrographic information from the CTD, using timestamps as an
index (see "A note on location information" in \sQuote{Details}).
If the user supplies a value for \code{tzOffsetLocation}, then that is used.
If not, an attempt is made to infer it from a table named \code{epochs} in the
file. If no value can be inferred from either of these two methods, then
\code{tzOffsetLocation} is set to zero.}

\item{patm}{controls the handling of atmospheric pressure, an important issue
for RBR instruments that record absolute pressure; see \dQuote{Details}.}

\item{allTables}{logical value, TRUE by default, indicating whether to save
all the non-empty tables in the database (pruned of \code{blob} columns) in the
\code{metadata} slot of the returned object. This may be useful for detailed
analysis.}

\item{processingLog}{if provided, the action item to be stored in the log.
This is typically only provided for internal calls; the default that it provides
is better for normal calls by a user.}

\item{debug}{a flag that can be set to \code{TRUE} to turn on debugging.}
}
\value{
An \linkS4class{rsk} object.
}
\description{
Read an RBR rsk or txt file, e.g. as produced by an RBR logger, producing an
object of class \code{rsk}.
}
\details{
This can read files produced by several RBR instruments.  At the moment, five
styles are understood: (1) text file produced as an export of an RBR \code{hex}
or \code{rsk} file; (2) text file with columns for temperature and pressure
(with sampling times indicated in the header); (3) text file with four columns,
in which the date the time of day are given in the first two columns, followed
by the temperature, and pressure; (4) text file with five columns, in which
depth in the water column is given after the pressure; (5) an SQLite-based
database format. The first four options are provided mainly for historical
reasons, since RBR instruments at the date of writing commonly use the SQLite
format, though the first option is common for all instruments that produce a
\code{hex} file that can be read using Ruskin.
Options 2-4 are mostly obsolete, and will be removed from future versions.

\strong{A note on location information.}
It is possible to couple RBR CTD devices with smart phones or tablets
(see RBR-global, 2020), with the location data from the latter being stored
in the output \code{.rsk} file. The format does not seem to be documented by RBR,
but \code{read.rsk()} attempts to infer location nevertheless.
The procedure involves comparing the \code{tstamp} (time-stamp)
field from the hydrographic part of the dataset (which is in a database
table named \code{data}) with the \code{tstamp} field in the geographical part of the
dataset (in a table named \code{geodata}). (The \code{geodata} entries are filtered to
those for which the \code{origin} field equals \code{"auto"}. This seems to align
with times shown for "LOCATION" data in RBR-provided viewing software.)
The connection between the two fields is done with \code{\link[=approx]{approx()}}, after
adding \code{tzOffsetLocation} (with units converted appropriately) to the
time inferred from \code{geodata$tstamp} field, to account for the fact that phones and tablets
may be set to local time. If the procedure succeeds, then \code{longitude} and
\code{latitude} are inserted into the \code{metadata} slot of the return value, in the
form of vectors with the same length as \code{pressure} in the \code{data} slot.

\strong{A note on conductivity.}
RBR devices record conductivity in mS/cm, and it
is this value that is stored in the object returned by \code{read.rsk}. This can
be converted to conductivity ratio (which is what many other instruments report)
by dividing by 42.914 (see Culkin and Smith, 1980) which will be necessary in
any seawater-related function that takes conductivity ratio as an argument (see
\dQuote{Examples}).

\strong{A note on pressure.}
RBR devices tend to record absolute pressure (i.e.
sea pressure plus atmospheric pressure), unlike most oceanographic instruments
that record sea pressure (or an estimate thereof).  The handling of pressure
is controlled with the \code{patm} argument, for which there are three
possibilities.  (1) If \code{patm} is \code{FALSE} (the default), then
pressure read from the data file is stored in the \code{data} slot of return
value, and the \code{metadata} item \code{pressureType} is set to the string
\code{"absolute"}.  (2) If \code{patm} is \code{TRUE}, then an estimate of
atmospheric pressure is subtracted from the raw data. For data files in the
SQLite format (i.e.  \verb{*.rsk} files), this estimate will be the value read
from the file, or the ``standard atmosphere'' value 10.1325 dbar, if the file
lacks this information.  (3) If \code{patm} is a numerical value (or list of
values, one for each sampling time), then `patm` is subtracted from the
raw data.  In cases 2 and 3, an additional column named
`pressureOriginal` is added to the `data` slot to store the value
contained in the data file, and `pressureType` is set to a string
starting with `"sea"`.  See \code{\link[=as.ctd]{as.ctd()}} for details of how this
setup facilitates the conversion of \linkS4class{rsk} objects to
\linkS4class{ctd} objects.
}
\references{
Culkin, F., and Norman D. Smith, 1980. Determination of the concentration of
potassium chloride solution having the same electrical conductivity, at 15 C and
infinite frequency, as standard seawater of salinity 35.0000 ppt (Chlorinity
19.37394 ppt). \emph{IEEE Journal of Oceanic Engineering}, \strong{5}, pp 22-23.

RBR-global.com, 2020. “Ruskin User Guide.” RBR, August 18, 2020.
Revision RBR#0006105revH.
}
\seealso{
The documentation for \linkS4class{rsk} explains the structure of
\code{rsk} objects, and also outlines other functions dealing with them.  Since
RBR has a wide variety of instruments, \code{rsk} datasets can be quite general,
and it is common to coerce \code{rsk} objects to other forms for specialized
work, e.g. \code{\link[=as.ctd]{as.ctd()}} can be used to create CTD object, so that the
generic plot obeys the CTD format.

Other things related to rsk data: 
\code{\link{[[,rsk-method}},
\code{\link{[[<-,rsk-method}},
\code{\link{as.rsk}()},
\code{\link{ctdFindProfilesRBR}()},
\code{\link{plot,rsk-method}},
\code{\link{rsk-class}},
\code{\link{rskPatm}()},
\code{\link{rskToc}()},
\code{\link{rsk}},
\code{\link{subset,rsk-method}},
\code{\link{summary,rsk-method}}
}
\author{
Dan Kelley and Clark Richards
}
\concept{things related to rsk data}
