% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/section.R
\name{sectionSort}
\alias{sectionSort}
\title{Sort a Section}
\usage{
sectionSort(section, by)
}
\arguments{
\item{section}{A \code{section} object containing the section whose stations
are to be sorted.}

\item{by}{An optional string indicating how to reorder.  If not provided,
\code{"stationID"} will be assumed.  Other choices are \code{"distance"}, for
distance from the first station, \code{"longitude"}, for longitude,
\code{"latitude"} for latitude, and \code{"time"}, for time.}
}
\value{
An object of \code{\link{section-class}} that has less lateral
variation than the input section.
}
\description{
Sections created with \code{\link{as.section}} have "stations" that are in the
order of the CTD objects (or filenames for such objects) provided.  Sometimes,
this is not the desired order, e.g. if file names discovered with
\code{\link{dir}} are in an order that makes no sense.  (For example, a
practioner might name stations \code{"stn1"}, \code{"stn2"}, etc., not
realizing that this will yield an unhelpful ordering, by file name, if there
are more than 9 stations.) The purpose of \code{sectionSort} is to permit
reordering the constituent stations in sensible ways.
}
\examples{
\dontrun{
# Eastern North Atlantic, showing Mediterranean water;
# sorting by longitude makes it easier to compare
# the map and the section.
library(oce)
data(section)
s <- sectionGrid(subset(section, -30 <= longitude))
ss <- sectionSort(ss, by="longitude")
plot(ss)
}

}
\seealso{
Other things related to section data: \code{\link{[[,section-method}},
  \code{\link{[[<-,section-method}},
  \code{\link{as.section}},
  \code{\link{handleFlags,section-method}},
  \code{\link{initializeFlagScheme,section-method}},
  \code{\link{plot,section-method}},
  \code{\link{read.section}}, \code{\link{section-class}},
  \code{\link{sectionAddStation}},
  \code{\link{sectionGrid}}, \code{\link{sectionSmooth}},
  \code{\link{section}},
  \code{\link{subset,section-method}},
  \code{\link{summary,section-method}}
}
\author{
Dan Kelley
}
\concept{things related to section data}
