% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oce.R
\name{read.oce}
\alias{read.oce}
\title{Read an Oceanographic Data File}
\usage{
read.oce(file, ...)
}
\arguments{
\item{file}{a connection or a character string giving the name of the file
to load.}

\item{...}{arguments to be handed to whichever instrument-specific reading
function is selected, based on the header.}
}
\value{
An object of \code{\link{oce-class}} that is
specialized to the data type, e.g. \code{\link{ctd-class}},
if the data file contains \code{ctd} data.
}
\description{
Read an oceanographic data file, auto-discovering the file type from the
first line of the file.
This function tries to infer the file type from the first line, using
\code{\link{oceMagic}}.  If it can be discovered, then an
instrument-specific file reading function is called, with the \code{file}
and with any additional arguments being supplied.
}
\examples{

library(oce)
x <- read.oce(system.file("extdata", "ctd.cnv", package="oce"))
plot(x) # summary with TS and profiles
plotTS(x) # just the TS
}
\seealso{
The file type is determined by \code{\link{oceMagic}}.  If the file
type can be determined, then one of the following is called:
\code{\link{read.ctd}}, \code{\link{read.coastline}}
\code{\link{read.lobo}}, \code{\link{read.rsk}},
\code{\link{read.sealevel}}, etc.
}
\author{
Dan Kelley
}
