% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{mapTissot}
\alias{mapTissot}
\title{Add Tissot Indicatrices to a Map}
\usage{
mapTissot(grid = rep(15, 2), scale = 0.2, crosshairs = FALSE, ...)
}
\arguments{
\item{grid}{numeric vector of length 2, specifying the increment in
longitude and latitude for the grid. Indicatrices are drawn at e.g.
longitudes \code{seq(-180, 180, grid[1])}.}

\item{scale}{numerical scale factor for ellipses. This is multiplied by
\code{min(grid)} and the result is the radius of the circle on the
earth, in latitude degrees.}

\item{crosshairs}{logical value indicating whether to draw constant-latitude
and constant-longitude crosshairs within the ellipses.  (These are drawn
with 10 line segments each.) This can be helpful in cases where it is
not desired to use \code{\link{mapGrid}} to draw the longitude/latitude
grid.}

\item{\dots}{extra arguments passed to plotting functions, e.g.
\code{col="red"} yields red indicatrices.}
}
\description{
Plot ellipses at grid intersection points, as a method for
indicating the distortion inherent in the projection [1].
(Each ellipse is drawn with 64 segments.)
}
\details{
The purpose and interpretation are outlined in [1], but should also be
self-explanatory.
}
\examples{
\donttest{
library(oce)
data(coastlineWorld)
par(mfrow=c(1, 1), mar=c(2, 2, 1, 1))
p  <- "+proj=aea +lat_1=10 +lat_2=60 +lon_0=-45"
mapPlot(coastlineWorld, projection=p, col="gray",
longitudelim=c(-90,0), latitudelim=c(0, 50))
mapTissot(c(15, 15), col='red')
}

}
\references{
1. Snyder, John P., 1987.  Map Projections: A Working Manual.  USGS
Professional Paper: 1395 (available at
\url{https://pubs.er.usgs.gov/publication/pp1395}).
}
\seealso{
A map must first have been created with \code{\link{mapPlot}}.

Other functions related to maps: \code{\link{lonlat2map}},
  \code{\link{lonlat2utm}}, \code{\link{map2lonlat}},
  \code{\link{mapArrows}}, \code{\link{mapAxis}},
  \code{\link{mapContour}},
  \code{\link{mapDirectionField}}, \code{\link{mapGrid}},
  \code{\link{mapImage}}, \code{\link{mapLines}},
  \code{\link{mapLocator}},
  \code{\link{mapLongitudeLatitudeXY}},
  \code{\link{mapPlot}}, \code{\link{mapPoints}},
  \code{\link{mapPolygon}}, \code{\link{mapScalebar}},
  \code{\link{mapText}}, \code{\link{oceCRS}},
  \code{\link{shiftLongitude}}, \code{\link{usrLonLat}},
  \code{\link{utm2lonlat}}
}
\author{
Dan Kelley
}
\concept{functions related to maps}
