% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsk.R
\docType{methods}
\name{summary,rsk-method}
\alias{summary,rsk-method}
\title{Summarize a Rsk Object}
\usage{
\S4method{summary}{rsk}(object, ...)
}
\arguments{
\item{object}{An object of class \code{"rsk"}, usually, a result of a call to
\code{\link{read.rsk}}, \code{\link{read.oce}}, or \code{\link{as.rsk}}.}

\item{...}{Further arguments passed to or from other methods.}
}
\description{
Summarizes some of the data in a \code{rsk} object, presenting such information
as the station name, sampling location, data ranges, etc.
}
\examples{
library(oce)
data(rsk)
summary(rsk)

}
\seealso{
The documentation for \code{\link{rsk-class}} explains the structure
of CTD objects, and also outlines the other functions dealing with them.

Other things related to \code{rsk} data: \code{\link{[[,rsk-method}},
  \code{\link{[[<-,rsk-method}}, \code{\link{as.rsk}},
  \code{\link{plot,rsk-method}}, \code{\link{read.rsk}},
  \code{\link{rsk-class}}, \code{\link{rskPatm}},
  \code{\link{rskToc}}, \code{\link{rsk}},
  \code{\link{subset,rsk-method}}
}
\author{
Dan Kelley
}
