% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adv.R
\docType{methods}
\name{subset,adv-method}
\alias{subset,adv-method}
\title{Subset an ADV Object}
\usage{
\S4method{subset}{adv}(x, subset, ...)
}
\arguments{
\item{x}{An \code{adv} object, i.e. one inheriting from \code{\link{adv-class}}.}

\item{subset}{a condition to be applied to the \code{data} portion of \code{x}.
See \sQuote{Details}.}

\item{\dots}{ignored.}
}
\value{
A new \code{\link{adv-class}} object.
}
\description{
Subset an adv (acoustic Doppler profile) object.  This function is somewhat
analogous to \code{\link{subset.data.frame}}, except that subsets can only be
specified in terms of \code{time}.
}
\examples{
library(oce)
data(adv)
plot(adv)
plot(subset(adv, time < mean(range(adv[['time']]))))

}
\seealso{
Other things related to \code{adv} data: \code{\link{[[,adv-method}},
  \code{\link{[[<-,adv-method}}, \code{\link{adv-class}},
  \code{\link{adv}}, \code{\link{beamName}},
  \code{\link{beamToXyz}}, \code{\link{enuToOtherAdv}},
  \code{\link{enuToOther}}, \code{\link{plot,adv-method}},
  \code{\link{read.adv.nortek}},
  \code{\link{read.adv.sontek.adr}},
  \code{\link{read.adv.sontek.serial}},
  \code{\link{read.adv.sontek.text}},
  \code{\link{read.adv}}, \code{\link{summary,adv-method}},
  \code{\link{toEnuAdv}}, \code{\link{toEnu}},
  \code{\link{velocityStatistics}},
  \code{\link{xyzToEnuAdv}}, \code{\link{xyzToEnu}}
}
\author{
Dan Kelley
}
