% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coastline.R
\name{coastlineCut}
\alias{coastlineCut}
\title{Cut a Coastline Object at Specified Longitude}
\usage{
coastlineCut(coastline, lon_0 = 0)
}
\arguments{
\item{coastline}{original coastline object}

\item{lon_0}{longitude as would be given in a \code{+lon_0=} item in a proj.4 string}
}
\value{
a new coastline object
}
\description{
This can be helpful in preventing \code{\link{mapPlot}} from producing ugly
horizontal lines in world maps. These lines occur when a coastline segment
is intersected by longitude lon_0+180.  Since the coastline files in the oce
and ocedata packages are already "cut" at longitudes of -180 and 180, the present
function is not needed for default maps, which have \code{+lon_0=0}. However,
may help with other values of \code{lon_0}.
}
\section{Caution}{

This function is provisional. Its behaviour, name and very existence
may change through the late months of 2015.  One part of the
development plan is to see if there is common ground between this
and the \code{clipPolys} function in the \CRANpkg{PBSmapping} package.
}
\examples{
library(oce)
data(coastlineWorld)
\dontrun{
mapPlot(coastlineCut(coastlineWorld, lon_0=100), proj="+proj=robin +lon_0=100", fill='gray')
}

}
\seealso{
Other things related to \code{coastline} data: \code{\link{[[,coastline-method}},
  \code{\link{[[<-,coastline-method}},
  \code{\link{as.coastline}},
  \code{\link{coastline-class}},
  \code{\link{coastlineBest}},
  \code{\link{coastlineWorld}},
  \code{\link{plot,coastline-method}},
  \code{\link{read.coastline.openstreetmap}},
  \code{\link{read.coastline.shapefile}},
  \code{\link{subset,coastline-method}},
  \code{\link{summary,coastline-method}}
}

