% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{centroidDetection}
\alias{centroidDetection}
\title{Centroid detection function}
\usage{
centroidDetection(
  df,
  xf,
  yf,
  cf,
  idf,
  .ntv.ctry,
  .inv.ctry,
  .points.proj4string,
  .r.env,
  .countries.shapefile,
  cfsf,
  method = "all",
  do = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{df}{data.frame of species occurrences}

\item{xf}{character. column name in df containing the x coordinates}

\item{yf}{character. column name in df containing the y coordinates}

\item{idf}{character. Column with the taxon observation ID.}

\item{.ntv.ctry}{character. ISO3 country codes where species are considered native}

\item{.inv.ctry}{character. ISO3 country codes where species are considered alien}

\item{.points.proj4string}{Proj4string argument. Coordinate reference system}

\item{.r.env}{raster. Raster of environmental variables considered in the analysis}

\item{.countries.shapefile}{spatialPolygonDataFrame of political divisions}

\item{cfsf}{character. Column name of the .country spatialPolygonDataFrame indicating the country in ISO3 coding.}

\item{method}{character. Vector with the methods to detect centroids}

\item{do}{logical. Should range analysis be performed? Default TRUE}

\item{verbose}{logical. Print messages? Default FALSE}

\item{.c.field}{character. Country field in the species data.frame (df)}
}
\value{
data.frame
}
\description{
Identify occurrence records located near centroids.
}
\details{
Current methods implemented for centroid detection are 'BIEN' (uses iterative procedure with threshold selection of distance to centroid)\cr
, and method 'CoordinateCleaner' implementing methods used in \link[CoordinateCleaner]{CoordinateCleaner-package} package.
}
\seealso{
\link[CoordinateCleaner]{cc_cap} \link[CoordinateCleaner]{cc_cen}

Other analysis: 
\code{\link{.nearestcell3}()},
\code{\link{countryStatusRangeAnalysis}()},
\code{\link{duplicatesexcludeAnalysis}()},
\code{\link{geoEnvAccuracy}()},
\code{\link{humanDetection}()}
}
\author{
Brian Maitner, Josep M Serra-Diaz, Cory Merow. Functions from CoordinateCleaner implemented by A Zizka (CoordinateCleaner)
}
\concept{analysis}
\keyword{internal}
