% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voxel_selection.R
\name{voxel_selection}
\alias{voxel_selection}
\title{Voxel Selection Procedure}
\usage{
voxel_selection(flair, brain_mask, cutoff)
}
\arguments{
\item{flair}{FLAIR volume of class \code{\link{nifti}}}

\item{brain_mask}{brain mask of class \code{\link{nifti}}}

\item{cutoff}{the percentile cutoff for the thresholding, 
passed to \code{\link{quantile}}}
}
\value{
Returns the voxel selection mask as an object of class \code{\link{nifti}}.
}
\description{
This function creates a binary mask for the voxel selection 
procedure for OASIS.
}
\examples{
library(oasis)
niis = tempfile(fileext = ".nii.gz")
if (require(downloader)) {
 download(paste0("https://dl.dropbox.com/u/2785709/brainder", 
         "/software/flair/templates/GG-853-FLAIR-2.0mm.nii.gz"), 
         destfile = niis)
 
 flair <- readnii(niis) 
 if (have.fsl()) {
   brain_mask = fslbet(niis) > 0
 } else {
   ind = list(c(10L, 81L), c(12L, 101L), c(3L, 78L))
   all.ind = lapply(ind, function(x) seq(x[1], x[2]))
   brain_mask = niftiarr(flair, 0)
   eg = expand.grid(all.ind)
   eg = as.matrix(eg)
   brain_mask[eg] = 1
 }
 voxel_selection_mask <- voxel_selection(flair, 
   brain_mask, cutoff = .85) 
}
}

