% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.node.R
\name{as.node}
\alias{as.node}
\alias{as.node.character}
\alias{as.node.tree}
\title{Conversion to a node}
\usage{
as.node(x, ...)

\method{as.node}{character}(x, ...)

\method{as.node}{tree}(x, ...)
}
\arguments{
\item{x}{An object to be converted.}

\item{...}{Additional parameters.}
}
\value{
A node.
}
\description{
These methods convert an object to a node. 
A node is defined as an \code{rtree} object with no subtrees.
}
\examples{
## Rooted tree
(tr0 = c_("Bob", "Carl", "Daniel"))
(tr1 = c_("Bill", "Caroline", "Dimitri", "Enoc"))
(tr2 = r_("Alice", s = list(tr0, tr1)))
as.node(tr2) # the root of 'tr2'

## Unrooted tree
(tr3 = r_(s = list(tr2, c_("Grand-Mother", "Father", "Son"))))
\dontrun{
as.node(tr3) # generates an error since 'tr3' is unrooted
}

}
