% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_fine-tunes.R
\name{fine_tunes_create_request}
\alias{fine_tunes_create_request}
\title{API fine tunes: create (model) request}
\usage{
fine_tunes_create_request(
  api_key,
  training_file,
  validation_file = NULL,
  model = NULL,
  n_epochs = NULL,
  batch_size = NULL,
  learning_rate_multiplier = NULL,
  prompt_loss_weight = NULL,
  compute_classification_metrics = NULL,
  classification_n_classes = NULL,
  classification_positive_class = NULL,
  classification_betas = NULL,
  suffix = NULL
)
}
\arguments{
\item{api_key}{string, OpenAI API key
(see https://platform.openai.com/account/api-keys)}

\item{training_file}{string, the ID of an uploaded file that contains
training data. See files_upload_request().}

\item{validation_file}{string/NULL, the ID of an uploaded file that contains
validation data.}

\item{model}{string, the name of the base model to fine-tune.
You can select one of "ada", "babbage", "curie", "davinci", or a fine-tuned
model created after 2022-04-21. To learn more about these models, see the
models (https://platform.openai.com/docs/models) documentation.}

\item{n_epochs}{integer, the number of epochs to train the model for.
An epoch refers to one full cycle through the training dataset.}

\item{batch_size}{integer/NULL, the batch size to use for training.
The batch size is the number of training examples used to train a single
forward and backward pass. By default, the batch size will be dynamically
configured to be ~0.2% of the number of examples in the training set,
capped at 256 - in general, we've found that larger batch sizes tend
to work better for larger datasets.}

\item{learning_rate_multiplier}{double/NULL, the learning rate multiplier
to use for training. The fine-tuning learning rate is the original
learning rate used for pretraining multiplied by this value. By default,
the learning rate multiplier is the 0.05, 0.1, or 0.2 depending
on final batch_size (larger learning rates tend to perform better with larger
batch sizes). We recommend experimenting with values in the range 0.02 to 0.2
to see what produces the best results.}

\item{prompt_loss_weight}{double, The weight to use for loss on the prompt
tokens. This controls how much the model tries to learn to generate
the prompt (as compared to the completion which always has a weight of 1.0),
and can add a stabilizing effect to training when completions are short.
If prompts are extremely long (relative to completions), it may make sense
to reduce this weight so as to avoid over-prioritizing learning the prompt.}

\item{compute_classification_metrics}{flag, if set, we calculate
classification-specific metrics such as accuracy and F-1 score using
the validation set at the end of every epoch. These metrics can be viewed
in the results file. In order to compute classification metrics, you must
provide a validation_file. Additionally, you must specify
classification_n_classes for multiclass classification
or classification_positive_class for binary classification.}

\item{classification_n_classes}{integer/NULL, the number of classes in a
classification task. This parameter is required for multiclass classification.}

\item{classification_positive_class}{string/NULL, The positive class in
binary classification. This parameter is needed to generate precision,
recall, and F1 metrics when doing binary classification.}

\item{classification_betas}{array/NULL, if this is provided, we calculate
F-beta scores at the specified beta values. The F-beta score is a
generalization of F-1 score. This is only used for binary classification.
With a beta of 1 (i.e. the F-1 score), precision and recall are given the
same weight. A larger beta score puts more weight on recall and less on
precision. A smaller beta score puts more weight on precision and less on
recall.}

\item{suffix}{string/NULL, a string of up to 40 characters that will be added
to your fine-tuned model name. For example, a suffix of "my-model"
would produce a model name like ada:ft-your-org:my-model-2022-02-15-04-21-04.}
}
\value{
\link[httr]{content} of the httr \link[httr]{response} object
or SimpleError (\link[base]{conditions}) enhanced with
two additional fields: `status_code` (response$status_code)
and `message_long` (built on response content)
}
\description{
To get more details, visit https://platform.openai.com/docs/api-reference/fine-tunes/create
}
