% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deleteLayer.R
\name{deleteLayer}
\alias{deleteLayer}
\title{Deletes an existing layer}
\usage{
deleteLayer(labbcat.url, layer.id)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{layer.id}{The ID of the layer to delete.}
}
\value{
NULL, or an error message if deletion failed.
}
\description{
This function deletes an existing annotation layer, including all annotation data
associated with it.
}
\details{
You must have administration privileges in LaBB-CAT in order to be able to use this function.
}
\examples{
\dontrun{
## Delete the phonemes layer
deleteLayer(labbcat.url, "phonemes")
}

}
\seealso{
Other Annotation layer functions: 
\code{\link{generateLayer}()},
\code{\link{getLayer}()},
\code{\link{getLayerIds}()},
\code{\link{getLayers}()},
\code{\link{newLayer}()},
\code{\link{saveLayer}()}
}
\concept{Annotation layer functions}
\keyword{annotation}
\keyword{layer}
