% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nzilbb.labbcat.R
\name{getSoundFragment}
\alias{getSoundFragment}
\title{Gets a sound fragment from 'LaBB-CAT'.}
\usage{
getSoundFragment(labbcat.url, id, start, end, sampleRate = NULL,
  no.progress = FALSE)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{id}{The graph ID (transcript name) of the sound recording, or
a vector of graph IDs.}

\item{start}{The start time in seconds, or a vector of start times.}

\item{end}{The end time in seconds, or a vector of end times.}

\item{sampleRate}{Optional sample rate in Hz - if a positive
integer, then the result is a mono file with the given sample rate.}

\item{no.progress}{Optionally suppress the progress bar when
multiple fragments are  specified - TRUE for no progress bar.}
}
\value{
The name of the file, which is saved in the current
    directory, or a list of names of files, if multiple
    id's/start's/end's were specified 

If a list of files is returned, they are in the order that they
    were returned by the server, which *should* be the order that
    they were specified in the id/start/end lists.
}
\description{
Gets a sound fragment from 'LaBB-CAT'.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## specify the username/password in the script
## (only use labbcatCredentials for scripts that must execute unsupervised!)
labbcatCredentials(labbcat.url, "demo", "demo")

## Get the 5 seconds starting from 10s after the beginning of a recording
wav.file <- getSoundFragment(labbcat.url, "AP2505_Nelson.eaf", 10.0, 15.0)

## Get the 5 seconds starting from 10s as a mono 22kHz file
wav.file <- getSoundFragment(labbcat.url, "AP2505_Nelson.eaf", 10.0, 15.0, 22050)

## Load some search results, normally something like:
##  results <- read.csv("results.csv", header=T)
## ...but for demonstration purposes:
results <- data.frame(
             id=c("AP2505_Nelson.eaf", "AP2512_MattBlack.eaf", "AP2512_MattBlack.eaf"),
             start=c(10.0, 20.0, 30.0),
             end=c(15.0, 25.0, 35.0))

## Get a list of fragments
wav.files <- getSoundFragment(labbcat.url, results$id, results$start, results$end)

## Get a list of fragments with no prgress bar
wav.file <- getSoundFragment(
              labbcat, results$id, results$start, results$end, no.progress=TRUE)
}
}
\keyword{fragment}
\keyword{sample}
\keyword{sound}
\keyword{wav}
