% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_text_bar.R
\name{f_text_bar}
\alias{f_text_bar}
\alias{ff_text_bar}
\title{Format Text Based Bar Plots}
\usage{
f_text_bar(x, symbol = "_", width = 9, ...)

ff_text_bar(...)
}
\arguments{
\item{x}{A numeric vector.}

\item{symbol}{A sumbol to use for the bars.}

\item{width}{The max width of the bar.}

\item{\ldots}{ignored.}
}
\value{
Returns a vector of concatenated symbols as a string that represent x% of the bar.
}
\description{
Use a text symbol to create scaled horizontal bar plots of numeric vectors.
Note that you will have to coerce the table to a \code{data.frame} in order
for the output to look pretty.
}
\examples{
\dontrun{
library(dplyr)

mtcars \%>\%
    count(cyl, gear) \%>\%
    group_by(cyl) \%>\%
    mutate(
        p = numform::f_pp(n/sum(n))
    ) \%>\%
    ungroup() \%>\%
    mutate(
        cyl = numform::fv_runs(cyl),
        ` ` = f_text_bar(n)  ## Overall
    ) \%>\%
    as.data.frame()

mtcars \%>\%
    count(cyl, gear) \%>\%
    group_by(cyl) \%>\%
    mutate(
        p = numform::f_pp(n/sum(n)),
        ` ` = f_text_bar(n) ## within groups
    ) \%>\%
    ungroup() \%>\%
    mutate(
        cyl = numform::fv_runs(cyl),
        ` ` = f_text_bar(n)
    ) \%>\%
    as.data.frame()

mtcars \%>\%
    count(cyl, gear) \%>\%
    group_by(cyl) \%>\%
    mutate(
        p = numform::f_pp(n/sum(n)),
        `within` = f_text_bar(n, width = 3, symbol = '#')
    ) \%>\%
    ungroup() \%>\%
    mutate(
        cyl = numform::fv_runs(cyl),
        `overall` = f_text_bar(n, width = 30, symbol = '*')
    ) \%>\%
    as.data.frame() \%>\%
    pander::pander(split.tables = Inf, justify = alignment(.), style = 'simple')

## Drop the headers
mtcars \%>\%
    count(cyl, gear) \%>\%
    group_by(cyl) \%>\%
    mutate(
        p = numform::f_pp(n/sum(n)),
        `   ` = f_text_bar(n, symbol = '=')
    ) \%>\%
    ungroup() \%>\%
    mutate(
        cyl = numform::fv_runs(cyl),
        ` ` = f_text_bar(n, symbol = '#')
    ) \%>\%
    as.data.frame()
}
}
