% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{analyze_bulk}
\alias{analyze_bulk}
\title{Call CNVs in a pseudobulk profile using the Numbat joint HMM}
\usage{
analyze_bulk(
  bulk,
  t = 1e-05,
  gamma = 20,
  theta_min = 0.08,
  logphi_min = 0.25,
  nu = 1,
  min_genes = 10,
  exp_only = FALSE,
  allele_only = FALSE,
  bal_cnv = TRUE,
  retest = TRUE,
  find_diploid = TRUE,
  diploid_chroms = NULL,
  segs_loh = NULL,
  classify_allele = FALSE,
  run_hmm = TRUE,
  prior = NULL,
  exclude_neu = TRUE,
  phasing = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{bulk}{dataframe Pesudobulk profile}

\item{t}{numeric Transition probability}

\item{gamma}{numeric Dispersion parameter for the Beta-Binomial allele model}

\item{theta_min}{numeric Minimum imbalance threshold}

\item{logphi_min}{numeric Minimum log expression deviation threshold}

\item{nu}{numeric Phase switch rate}

\item{min_genes}{integer Minimum number of genes to call an event}

\item{exp_only}{logical Whether to run expression-only HMM}

\item{allele_only}{logical Whether to run allele-only HMM}

\item{bal_cnv}{logical Whether to call balanced amplifications/deletions}

\item{retest}{logical Whether to retest CNVs after Viterbi decoding}

\item{find_diploid}{logical Whether to run diploid region identification routine}

\item{diploid_chroms}{character vector User-given chromosomes that are known to be in diploid state}

\item{segs_loh}{dataframe Segments with clonal LOH to be excluded}

\item{classify_allele}{logical Whether to only classify allele (internal use only)}

\item{run_hmm}{logical Whether to run HMM (internal use only)}

\item{prior}{numeric vector Prior probabilities of states (internal use only)}

\item{exclude_neu}{logical Whether to exclude neutral segments from retesting (internal use only)}

\item{phasing}{logical Whether to use phasing information (internal use only)}

\item{verbose}{logical Verbosity}
}
\value{
a pseudobulk profile dataframe with called CNV information
}
\description{
Call CNVs in a pseudobulk profile using the Numbat joint HMM
}
\examples{
bulk_analyzed = analyze_bulk(bulk_example, t = 1e-5, find_diploid = FALSE, retest = FALSE)
}
