#pragma once

#include "Filter.h"


template <typename TASK>
class MinLengthFilter : public Filter<TASK> {
public:
    MinLengthFilter(int minLength)
        : minLength(minLength)
    { }

    bool isStorable(const TASK& task) const override
    { return ((int) task.getLength()) >= minLength; }

private:
    int minLength;
};
