% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ntd.R
\name{get_ntd}
\alias{get_ntd}
\title{Get NTD data}
\usage{
get_ntd(
  agency = "all",
  data_type = "adjusted",
  ntd_variable = "UPT",
  modes = "all",
  cache = FALSE
)
}
\arguments{
\item{agency}{Name of the transit agency to retrieve. Defaults to `all` agencies}

\item{data_type}{Type of NTD data. Either "raw" for data released without adjustments or "adjusted" for data with adjustments and estimates}

\item{ntd_variable}{Which variable to return. `UPT` for unlinked passenger trips, `VRM` for vehicle revenue miles, `VRH` for vehicle revenue hours, or `VOMS` for vehicles operated in maximum service.}

\item{modes}{Transit mode to retrieve. Common modes include `MB` (bus), `CR` (commuter rail), `HR` (heavy rail), `LR` (light rail). Defaults to `all` modes.}

\item{cache}{Cache downloaded data. Defaults to `FALSE`.}
}
\value{
A data frame of monthly NTD data with the requested ntd_variable in the `value` column
}
\description{
Get NTD data
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
get_ntd(agency = "City of Madison", modes = c("MB", "DR"))
\dontshow{\}) # examplesIf}
}
