% Generated by roxygen2 (4.0.2): do not edit by hand
\name{simulategp.perturbed}
\alias{simulategp.perturbed}
\title{Generate simulated perturbed GP models}
\usage{
simulategp.perturbed(N = 100, reps = 3, obs = c(0, 5, 10, 15, 20),
  gps.ctrl = NULL, filename = NULL, xs = seq(0, 20, 0.2), l.noise = 12,
  l.shape = 2, l.scale = 2.5, sigmaf.noise = 0.25, sigmaf.shape = 4,
  sigmaf.scale = 0.5)
}
\arguments{
\item{N}{number of gp's}

\item{reps}{replicate observations}

\item{obs}{observation timepoints}

\item{gps.ctrl}{the GPS models to be perturbed}

\item{filename}{file to save the results}

\item{xs}{target timepoints}

\item{l.noise}{Noise model lengthscale}

\item{l.shape}{shape of lengthscale Gamma distribution}

\item{l.scale}{scale of lengthscale Gamma distribution}

\item{sigmaf.noise}{Noise model sigma.f}

\item{sigmaf.shape}{shape of sigma.f Gamma distribution}

\item{sigmaf.scale}{scale of sigma.f Gamma distribution}
}
\value{
List with
 \item{simdata}{Simulated datamatrix}
 \item{gps}{Simulated GPs}
}
\description{
Takes pregenerated simulated GP models as input, and
 models both the perturbation and additional perturbation variance as
  GP models, that are all combined into a perturbed GP model. We sample
  \code{reps} data points from this at timepoints \code{obs}
}
\seealso{
\code{\link{simulategp}}
}

