% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/force.R
\name{forced}
\alias{forced}
\alias{forced.quotation}
\alias{forced.dots}
\alias{forced.default}
\alias{force_}
\alias{force_.quotation}
\alias{force_.dots}
\alias{value}
\alias{value.quotation}
\alias{value.dots}
\alias{values}
\alias{values.dots}
\title{Forcing and forcedness of arguments and quotations.}
\usage{
forced(x)

\method{forced}{quotation}(x, ...)

\method{forced}{dots}(x)

\method{forced}{default}(x)

force_(x, ...)

\method{force_}{quotation}(x, eval = base::eval, ...)

\method{force_}{dots}(x, ...)

value(x, ...)

\method{value}{quotation}(x, mode = "any", ...)

\method{value}{dots}(x, ...)

values(x)

\method{values}{dots}(x)
}
\arguments{
\item{x}{A \link{quotation} or \link{dots} object.}

\item{...}{Options used by methods}

\item{eval}{Which evaluation function to use.}

\item{mode}{Whether to force in "any" mode or "function" mode (see
\link{locate}).}
}
\value{
\code{forced(x)} returns a \link{logical}.

\code{value(x)} returns the result of forcing the quotation.

\code{values} returns a list.
}
\description{
There are two kinds of \link{quotation}s: forced and unforced.
Unforced quotations have an expression and an environment; forced
quotations have an expression and a value.

\code{forced(q)} tests whether a \link{quotation} is forced.

\code{forced(d)} on a \link{dots} object tests whether each element
is forced, and returns a logical vector.

\code{force_(x)} converts an unforced quotation or dots object into a
forced one, by evaluating it.

\code{value(x)} or \code{values(...)} returns the value of a quotation or dots,
forcing it if necessary.
}
\seealso{
is_forced forced_quo

\link{force}
}
