context("Test nse") 

test_that("Numeric & positive", { 
  n    = 1000
  ar   = 0.9
  mean = 1
  sd   = 1
   
  set.seed(1234)
  x = as.vector(arima.sim(n = n, list(ar = ar), sd = sd) + mean)
   
  # nse.geyer
  out = nse.geyer(x = x, type = "bm", nbatch = 30)
  expect_true(is.numeric(out) && out > 0)
  out = nse.geyer(x = x, type = "obm", nbatch = 30)
  expect_true(is.numeric(out) && out > 0)
  out = nse.geyer(x = x, type = "iseq", iseq.type = "pos")
  expect_true(is.numeric(out) && out > 0)
  out = nse.geyer(x = x, type = "iseq.bm", iseq.type = "con")
  expect_true(is.numeric(out) && out > 0)
  
  ## nse.spec0
  out = nse.spec0(x = x, type = "ar", lag.prewhite = 0)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "ar", lag.prewhite = 1)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "ar", lag.prewhite = NULL)
  out = nse.spec0(x = x, type = "glm", lag.prewhite = 0)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "glm", lag.prewhite = 1)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "glm", lag.prewhite = NULL)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "daniell", lag.prewhite = 0)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "daniell", lag.prewhite = 1)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "daniell", lag.prewhite = NULL)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "modified.daniell", lag.prewhite = 0)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "modified.daniell", lag.prewhite = 1)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "modified.daniell", lag.prewhite = NULL)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "tukey-hanning", lag.prewhite = 0)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "tukey-hanning", lag.prewhite = 1)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "tukey-hanning", lag.prewhite = NULL)
  expect_true(is.numeric(out) && out > 0)  
  out = nse.spec0(x = x, type = "parzen", lag.prewhite = 0)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "parzen", lag.prewhite = 1)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "parzen", lag.prewhite = NULL)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "parzen", lag.prewhite = 0, steep = TRUE)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "triweight", lag.prewhite = 0)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "triweight", lag.prewhite = 1)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "triweight", lag.prewhite = NULL)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "triangular", lag.prewhite = 0)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "triangular", lag.prewhite = 1)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "triangular", lag.prewhite = NULL)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "qs", lag.prewhite = 0, steep = TRUE)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "qs", lag.prewhite = 0)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "qs", lag.prewhite = 1)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "qs", lag.prewhite = NULL)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "qs", lag.prewhite = 0, steep = TRUE)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "bartlett-priestley", lag.prewhite = 0)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "bartlett-priestley", lag.prewhite = 1)
  expect_true(is.numeric(out) && out > 0)
  out = nse.spec0(x = x, type = "bartlett-priestley", lag.prewhite = NULL)
  expect_true(is.numeric(out) && out > 0)
  ## nse.nw
  out = nse.nw(x = x, lag.prewhite = 0)
  expect_true(is.numeric(out) && out > 0)
  out = nse.nw(x = x, lag.prewhite = 1)
  expect_true(is.numeric(out) && out > 0)
  out = nse.nw(x = x, lag.prewhite = NULL)
  expect_true(is.numeric(out) && out > 0)
  
  ## nse.andrews
  out = nse.andrews(x = x, type = "bartlett", lag.prewhite = 0)
  expect_true(is.numeric(out) && out > 0)
  out = nse.andrews(x = x, type = "bartlett", lag.prewhite = 1)
  expect_true(is.numeric(out) && out > 0)
  out = nse.andrews(x = x, type = "bartlett", lag.prewhite = NULL)
  expect_true(is.numeric(out) && out > 0)
  out = nse.andrews(x = x, type = "parzen", lag.prewhite = 0)
  expect_true(is.numeric(out) && out > 0)
  out = nse.andrews(x = x, type = "parzen", lag.prewhite = 1)
  expect_true(is.numeric(out) && out > 0)
  out = nse.andrews(x = x, type = "parzen", lag.prewhite = NULL)
  expect_true(is.numeric(out) && out > 0)
  out = nse.andrews(x = x, type = "tukey", lag.prewhite = 0)
  expect_true(is.numeric(out) && out > 0)
  out = nse.andrews(x = x, type = "tukey", lag.prewhite = 1)
  expect_true(is.numeric(out) && out > 0)
  out = nse.andrews(x = x, type = "tukey", lag.prewhite = NULL)
  expect_true(is.numeric(out) && out > 0)
  out = nse.andrews(x = x, type = "qs", lag.prewhite = 0)
  expect_true(is.numeric(out) && out > 0)
  out = nse.andrews(x = x, type = "qs", lag.prewhite = 1)
  expect_true(is.numeric(out) && out > 0)
  out = nse.andrews(x = x, type = "qs", lag.prewhite = NULL)
  expect_true(is.numeric(out) && out > 0)
  out = nse.andrews(x = x, type = "trunc", lag.prewhite = 0)
  expect_true(is.numeric(out) && out > 0)
  out = nse.andrews(x = x, type = "trunc", lag.prewhite = 1)
  expect_true(is.numeric(out) && out > 0)
  out = nse.andrews(x = x, type = "trunc", lag.prewhite = NULL)
  expect_true(is.numeric(out) && out > 0)
  
  ## nse.hiruk
  out = nse.hiruk(x = x, type = "bartlett", lag.prewhite = 0)
  expect_true(is.numeric(out) && out > 0)
  out = nse.hiruk(x = x, type = "bartlett", lag.prewhite = 1)
  expect_true(is.numeric(out) && out > 0)
  out = nse.hiruk(x = x, type = "bartlett", lag.prewhite = NULL)
  expect_true(is.numeric(out) && out > 0)
  out = nse.hiruk(x = x, type = "parzen", lag.prewhite = 0)
  expect_true(is.numeric(out) && out > 0)
  out = nse.hiruk(x = x, type = "parzen", lag.prewhite = 1)
  expect_true(is.numeric(out) && out > 0)
  out = nse.hiruk(x = x, type = "parzen", lag.prewhite = NULL)
  expect_true(is.numeric(out) && out > 0)
  
  ## nse.boot
  out = nse.boot(x = x, nb = 1000, type = "stationary", b = NULL, lag.prewhite = 0)
  expect_true(is.numeric(out) && out > 0)
  out = nse.boot(x = x, nb = 1000, type = "stationary", b = NULL, lag.prewhite = 1)
  expect_true(is.numeric(out) && out > 0)
  out = nse.boot(x = x, nb = 1000, type = "stationary", b = NULL, lag.prewhite = NULL)
  expect_true(is.numeric(out) && out > 0)
  out = nse.boot(x = x, nb = 1000, type = "stationary", b = 10, lag.prewhite = 0)
  expect_true(is.numeric(out) && out > 0)
  out = nse.boot(x = x, nb = 1000, type = "stationary", b = 10, lag.prewhite = 1)
  expect_true(is.numeric(out) && out > 0)
  out = nse.boot(x = x, nb = 1000, type = "stationary", b = 10, lag.prewhite = NULL)
  expect_true(is.numeric(out) && out > 0)
  out = nse.boot(x = x, nb = 1000, type = "circular", b = NULL, lag.prewhite = 0)
  expect_true(is.numeric(out) && out > 0)
  out = nse.boot(x = x, nb = 1000, type = "circular", b = NULL, lag.prewhite = 1)
  expect_true(is.numeric(out) && out > 0)
  out = nse.boot(x = x, nb = 1000, type = "circular", b = NULL, lag.prewhite = NULL)
  expect_true(is.numeric(out) && out > 0)
  out = nse.boot(x = x, nb = 1000, type = "circular", b = 10, lag.prewhite = 0)
  expect_true(is.numeric(out) && out > 0)
  out = nse.boot(x = x, nb = 1000, type = "circular", b = 10, lag.prewhite = 1)
  expect_true(is.numeric(out) && out > 0)
  out = nse.boot(x = x, nb = 1000, type = "circular", b = 10, lag.prewhite = NULL)
  expect_true(is.numeric(out) && out > 0)
}) 

test_that("Wrong dimension", { 
  n = 1000
  set.seed(1234)
  X = matrix(data = rnorm(2*n), n, 2)
  
  expect_error(nse.geyer(x = X))
  expect_error(nse.spec0(x = X))
  expect_error(nse.nw(x = X))
  expect_error(nse.andrews(x = X))
  expect_error(nse.hiruk(x = X))
  expect_error(nse.boot(x = X))
}) 