% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paket_nph_1-9.R
\name{logrank.test}
\alias{logrank.test}
\alias{print.wlogrank}
\title{Weighted log-rank test}
\usage{
logrank.test(
  time,
  event,
  group,
  alternative = c("two.sided", "less", "greater"),
  rho = 0,
  gamma = 0,
  weights = NULL
)
}
\arguments{
\item{time}{Vector of observed event/censored times}

\item{event}{logical vector indicating if an event was observed (TRUE) or the time is censored (FALSE)}

\item{group}{Vector of group allocations}

\item{alternative}{Either of \code{"two.sided"},\code{"less"} or \code{"greater"}, specifies if two-sided or respective
one-sided p-values are calculated. In any case the z test statistic of each included weighted log-rank test 
is based on the (weighted) sum of expected minus observed
events in the group corresponding to the first factor level of \code{group}. Hence a small value of the test statistic corresponds to a 
lower (weighted average) hazard rate in the first group.}

\item{rho}{Parameter to calculate weights in the rho-gamma family}

\item{gamma}{Parameter to calculate weights in the rho-gamma family}

\item{weights}{Optional vector of weights}
}
\value{
A list with elements:
\describe{
\item{\code{D}}{A data frame event numbers, numbers at risk and expected number of events for each event time}
\item{\code{test}}{A data frame containing the z and chi-squared statistic for the one-sided and two-sided test, respectively,
	of the null hypothesis of equal hazard functions in both groups and the p-value for the one-sided test.
}
\item{\code{var}}{The estimated variance of the sum of expected minus observed events in the first group.}
}
}
\description{
Calculates a weighted log-rank test for the comparison of two groups.
}
\details{
For a given sample, let \eqn{\mathcal{D}} be the set of unique event times.
For a time-point \eqn{t \in \mathcal{D}}, let \eqn{n_{t,ctr}} and \eqn{n_{t,trt}} be 
the number of patients at risk in the control and treatment group and let
\eqn{d_{t,ctr}} and \eqn{d_{t,trt}} be the respective number of events. 
The expected number of events in the control group is calculated under the
least favorable configuration in \eqn{H_0}, 
\eqn{\lambda_{ctr}(t) = \lambda_{trt}(t)}, as \eqn{e_{t,ctr}=(d_{t,ctr}+d_{t,trt}) 
\frac{n_{t0}}{n_{t0}+n_{t1}}}. The conditional variance of \eqn{d_{t,ctr}}
is calculated from a hypergeometric distribution as 
\eqn{var(d_{t,ctr})=\frac{n_{t0} n_{t1} (d_{t0}+d_{t1}) (n_{t0}+n_{t1} - d_{t0} - d_{t1})}{(n_{t0}+n_{t1})^2 (n_{t0}+n_{t1}-1)}}.
Further define a weighting function \eqn{w(t)}.
The weighted logrank test statistic for a comparison of two groups is 
\deqn{z=\sum_{t \in \mathcal{D}} w(t) (d_{t,ctr}-e_{t,ctr}) / \sqrt{\sum_{t \in \mathcal{D}} w(t)^2 var(d_{t,ctr})}}

Under the the least favorable configuration in \eqn{H_0}, 
the test statistic is asymptotically standard normally distributed and large 
values of \eqn{z} are in favor of the alternative.

The function consider particular weights in the Fleming-Harrington \eqn{\rho-\gamma} 
family \eqn{w(t)=\hat S(t)^\rho (1-\hat S(t))^\gamma}. 
Here, \eqn{\hat{S}(t)=\prod_{s \in \mathcal{D}: s \leq t} 1-\frac{d_{t,ctr}+d_{t,trt}}{n_{t,ctr}+n_{t,trt}}}
is the pooled sample Kaplan-Meier estimator. 
Weights \eqn{\rho=0, \gamma=0} correspond to the standard logrank test with 
constant weights \eqn{w(t)=1}. Choosing \eqn{\rho=0, \gamma=1} puts more weight on 
late events, \eqn{\rho=1, \gamma=0} puts more weight on early events and 
\eqn{\rho=1, \gamma=1} puts most weight on events at intermediate time points.
}
\examples{
A <- pop_pchaz(Tint = c(0, 90, 1500),
  lambdaMat1 = matrix(c(0.2, 0.1, 0.4, 0.1), 2, 2) / 365,
 lambdaMat2 = matrix(c(0.5, 0.2, 0.6, 0.2), 2, 2) / 365,
 lambdaProg = matrix(c(0.5, 0.5, 0.4, 0.4), 2, 2) / 365,
 p = c(0.8, 0.2), 
 timezero = FALSE, discrete_approximation = TRUE)
B <- pop_pchaz(Tint = c(0, 90, 1500),
  lambdaMat1 = matrix(c(0.2, 0.1, 0.4, 0.1), 2, 2) / 365,
 lambdaMat2 = matrix(c(0.5, 0.1, 0.6, 0.1), 2, 2) / 365,
 lambdaProg = matrix(c(0.5, 0.5, 0.04, 0.04), 2, 2) / 365,
 p = c(0.8, 0.2), 
 timezero = FALSE, discrete_approximation = TRUE)
dat <- sample_fun(A, B, r0 = 0.5, eventEnd = 30,
  lambdaRecr = 0.5, lambdaCens = 0.25 / 365,
 maxRecrCalendarTime = 2 * 365,
 maxCalendar = 4 * 365)
logrank.test(dat$y, dat$event, dat$group)


}
\references{
Thomas R Fleming and David P Harrington.Counting processes and survival anal-ysis, volume 169.  John Wiley & Sons, 2011
}
\seealso{
\code{\link{logrank.maxtest}}
}
\author{
Robin Ristl, \email{robin.ristl@meduniwien.ac.at}
}
