\name{plot.NpdeObject}
\alias{plot.NpdeObject}
\title{Plots a NpdeObject object}
\usage{
  \method{plot}{NpdeObject} (x, y, ...)
}
\arguments{
  \item{x}{a NpdeObject object}

  \item{y}{unused, here for compatibility with the base
  plot function}

  \item{\dots}{additional graphical parameters, which when
  given will supersede graphical preferences stored in the
  object}
}
\description{
  Plots the data and diagnostic plots in a NpdeObject
  object
}
\details{
  The default plot
}
\examples{
data(theopp)
data(simtheopp)

x<-autonpde(theopp,simtheopp,iid="ID",ix="Time", iy="Conc", boolsave=FALSE)
plot(x)
}
\references{
  K. Brendel, E. Comets, C. Laffont, C. Laveille, and
  F.Mentre. Metrics for external model evaluation with an
  application to the population pharmacokinetics of
  gliclazide. \emph{Pharmaceutical Research}, 23:2036--49,
  2006.
}
\seealso{
  \code{\link{set.plotoptions}}
}
\keyword{plot}

