% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{uroot.test}
\alias{uroot.test}
\title{The Unit root tests function}
\usage{
uroot.test(y,unit_root = c("adf","kpss","pp","box"),alpha = 0.05)
}
\arguments{
\item{y}{a numeric vector or an object of the \code{ts} class containing a stationary time series.}

\item{unit_root}{A character string naming the desired unit root test for checking stationarity.
Valid values are \code{"adf"} for the Augmented Dickey-Fuller, \code{"pp"} for the Phillips-Perron,
\code{"kpss"} for Kwiatkowski, Phillips, Schmidt, and Shin, and \code{"box"} for the Ljung-Box. The default
value is \code{"adf"} for the Augmented Dickey-Fuller test.}

\item{alpha}{Level of the test, possible values range from 0.01 to 0.1. By default \code{alpha = 0.05}
is used}
}
\value{
a h.test class with the main results of unit root hypothesis test.
}
\description{
Perform a unit root test to check stationarity in a linear stochastic process.
}
\details{
Several different tests are available:
In the  \code{kpss} test, the null hypothesis that \code{y} has a stationary root
against a unit-root alternative. In the two remaining tests, the null hypothesis
is that \code{y} has a unit root against a stationary root alternative. By default,
 \code{alpha = 0.05} is used to select the more likely hypothesis.
}
\examples{
#  stationary  ar process
y = arima.sim(100,model = list(ar = 0.3))
uroot.test(y)

# a random walk process
y = cumsum(y)
uroot.test(y,unit_root = "pp")

}
\references{
Dickey, D. & Fuller, W. (1979). Distribution of the Estimators for
Autoregressive Time Series with a Unit Root. \emph{Journal of the American
Statistical Association}. 74, 427-431.

Kwiatkowski, D., Phillips, P., Schmidt, P. & Shin, Y. (1992). Testing the Null
Hypothesis of Stationarity against the Alternative of a Unit Root,
\emph{Journal of Econometrics}. 54, 159-178.

Phillips, P. & Perron, P. (1988). Testing for a unit root in time series regression,
\emph{Biometrika}. 72(2), 335-346.

Ljung, G. M. & Box, G. E. P. (1978). On a measure of lack of fit in time series models.
\emph{Biometrika}. 65, 297-303.
}
\seealso{
\code{\link{normal.test}},\code{\link{seasonal.test}}
}
\author{
Asael Alonzo Matamoros and A. Trapletti
}
