\name{ms.filter}
\alias{ms.filter}

\title{
Flexible interactive filtering of components and/or peaks via polygon selection.
}
\description{
Mark peaks and components in plots of retention time, m/z, mass defect or peak intensity. Select components or peaks by drawing a polygon.  
}
\usage{
ms.filter(component, x = "mz", y = "dm", xlim = FALSE, 
ylim = FALSE, rm.comp = FALSE, plot.comp = TRUE, 
rm.noncomp = TRUE, select.polygon = "inside", res = 100, 
filter.for = "raw")
}

\arguments{
  \item{component}{
	List of type comp generated by \code{\link[nontarget]{combine}}.
	}
  \item{x}{
	Scale of x-axis, any of \code{"mz"} (m/z), \code{"dm"} (mass defect), \code{"rt"} (retention time) or \code{"int"} (intensity).
}
  \item{y}{
	Scale of y-axis, any of \code{"mz"} (m/z), \code{"dm"} (mass defect), \code{"rt"} (retention time) or \code{"int"} (intensity).
} 
  \item{xlim}{
	xlim=c(upper bound,lower bound), default = \code{FALSE}.
}
  \item{ylim}{
	ylim=c(upper bound,lower bound), default = \code{FALSE}.
}
  \item{rm.comp}{
	Select (i.e. remove) peaks assigned to components by \code{\link[nontarget]{combine}}?
}
  \item{plot.comp}{
	Highlight peaks part of a component (red)?
}
  \item{rm.noncomp}{
	Select (i.e. remove) peaks not assigned to components by \code{\link[nontarget]{combine}}?
}
  \item{select.polygon}{
	Select peaks and/or components to be excluded \code{"inside"} or \code{"outside"} of the polygon drawn?
}
  \item{res}{
	Resolution of polygon selection; increase if problems with selection by complicated polygons or along polygon boarder occur. Otherwise, ignore.
}
  \item{filter.for}{
	What should be filtered and subsequently returned as value by the polygon selection? Any of \code{"raw"} (raw data, i.e. peak list), \code{"pattern"} (isotope pattern peak relations, i.e. 
	subset of first entry in list of type pattern generated by \code{\link[nontarget]{pattern.search}}) or \code{"adduct"} (adduct relations, i.e. subset of 
	first entry in list of type adduct generated by \code{\link[nontarget]{adduct.search}})
	}

}
\details{
Selection refers to those peaks and/or components to be excluded. If not all peaks in the data set are assigned to components, they are still plotted
and can thus e.g. be separated from those assigned to components by setting \code{rm.comp} vs. \code{rm.noncomp}.
}
\value{
See \code{filter.for} argument.
Either raw data (i.e. peak list), isotope pattern peak relations, (i.e. subset of first entry in list of type pattern generated by \code{\link[nontarget]{pattern.search}}) or 
adduct relations (i.e. subset of first entry in list of type adduct generated by \code{\link[nontarget]{adduct.search}}).
}
\author{
Martin Loos
}
\note{
Here, mass defect is defined as the difference of m/z to the nearest integer from rounding.
\code{rm.comp = FALSE} and \code{rm.noncomp = FALSE} leads to no selection and thus no exclusions of anything.
}


\seealso{
	\code{\link[nontarget]{plotcomp}}
	\code{\link[nontarget]{combine}}
}



