% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safejoin.R
\name{safe_join.data.frame}
\alias{safe_join.data.frame}
\title{Join Data Frames Safely}
\usage{
\method{safe_join}{data.frame}(x, y, ...)
}
\arguments{
\item{x}{data.frame}

\item{y}{data.frame}

\item{...}{passed to \code{\link[dplyr]{left_join}}}
}
\description{
Joins data frames safely. I.e., a left join that 
cannot alter row order or number.  Supports the
case where you only intend to augment existing
rows with additional columns and are expecting
singular matches. Gives an error if row order
or number would have been altered by a left join.
}
\examples{
library(magrittr)
x <- data.frame(code = c('a','b','c'), value = c(1:3))
y <- data.frame(code = c('a','b','c'), roman = c('I','II','III'))
x \%>\% safe_join(y)
try(
x \%>\% safe_join(rbind(y,y))
)
}
\seealso{
Other safe_join: 
\code{\link{safe_join}()}
}
\concept{safe_join}
