% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partab.R
\name{partab.character}
\alias{partab.character}
\title{Create a Parameter Table from Model Name}
\usage{
\method{partab}{character}(x, verbose = FALSE, lo = "5", hi = "95",
  metafile = modelpath(x, "def", ...), xmlfile = modelpath(x, "xml", ...),
  ctlfile = modelfile(x, ...), bootcsv, strip.namespace = TRUE, skip = 28,
  check.names = FALSE, digits = 3, ci = TRUE, open = "(", close = ")",
  sep = ", ", format = TRUE, fields = c("symbol", "label", "unit"),
  relative = TRUE, percent = relative, nonzero = TRUE,
  shrinkage = FALSE, correlation = FALSE, ...)
}
\arguments{
\item{x}{a model name (numeric or character)}

\item{verbose}{set FALSE to suppress messages}

\item{lo}{the PsN bootstrap lower confidence limit (\%)}

\item{hi}{the PsN bootstrap upper confidence limit (\%)}

\item{metafile}{optional metadata for parameter table (see also: fields)}

\item{xmlfile}{path to xml file}

\item{ctlfile}{path to control stream}

\item{bootcsv}{path to PsN bootstrap_results.csv}

\item{strip.namespace}{whether to strip e.g. nm: from xml elements for easier xpath syntax}

\item{skip}{number of lines to skip in bootstrap_results.csv}

\item{check.names}{passed to bootstrap reader}

\item{digits}{limits numerics to significant digits (use NULL to suppress)}

\item{ci}{combine bootstrap lo and hi into an enclosed interval}

\item{open}{first character for bootstrap interval}

\item{close}{last character for bootstrap interval}

\item{sep}{separator for bootstrap interval}

\item{format}{format numerics as character}

\item{fields}{metadata fields to read from control stream.  See details.}

\item{relative}{transform standard errors to relative standard errors: rse replaces se}

\item{percent}{if relative is true, express as percent (else ignore): prse replaces se}

\item{nonzero}{limit random effects to those with nonzero estimates}

\item{shrinkage}{whether to include percent shrinkage on random effects}

\item{correlation}{whether to include correlation of random effects (as percent if \code{percent} is true)}

\item{...}{passed to other functions}
}
\value{
object of class partab, data.frame
}
\description{
Creates a parameter table from a model name. Pass the project argument or set 
the project option.
}
\details{
Normally you can just call the generic.  Suitable defaults are supplied, but much customization is supported by means of arguments documented here and in called functions.

Metadata can be added to the parameter table two ways: as markup in the control stream, and as a *.def file in the model directory.  See vignette('parameter-table') for details.
}
\examples{
library(magrittr)
options(project = system.file('project/model',package='nonmemica'))
1001 \%>\% partab
1001 \%>\% partab(shrinkage = TRUE, correlation = TRUE)
}
\seealso{
\code{\link{as.xml_document.character}}

\code{\link{as.bootstrap.character}}

\code{\link{as.model.character}}

\code{\link[csv]{as.csv}}

Other partab: \code{\link{partab.numeric}},
  \code{\link{partab}}
}
