% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likebut.R
\name{errors.character}
\alias{errors.character}
\title{Get Errors for Character}
\usage{
\method{errors}{character}(x, xmlfile = modelpath(x, ext = "xml", ...),
  strip.namespace = TRUE, digits = 3, ...)
}
\arguments{
\item{x}{character (modelname)}

\item{xmlfile}{path to xml file}

\item{strip.namespace}{whether to strip e.g. nm: from xml elements for easier xpath syntax}

\item{digits}{passed to signif}

\item{...}{dots}
}
\value{
numeric
}
\description{
Gets model asymptotic standard errors in canonical order, treating character as model names. 
See \code{\link{parameters}} for a less formal interface.
}
\examples{
library(magrittr)
options(project = system.file('project/model',package='nonmemica'))
1001 \%>\% errors
}
\seealso{
nms_canonical errors
}
