% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_amenity_sf.R
\name{geo_amenity_sf}
\alias{geo_amenity_sf}
\title{Get spatial objects of amenities}
\usage{
geo_amenity_sf(
  bbox,
  amenity,
  limit = 1,
  full_results = FALSE,
  return_addresses = TRUE,
  verbose = FALSE,
  custom_query = list(),
  points_only = TRUE,
  strict = FALSE
)
}
\arguments{
\item{bbox}{A numeric vector of latitude and longitude (<min_latitude>,
<min_longitude>, <max_latitude>, <max_longitude>) that restrict the search
area. See Details.}

\item{amenity}{A character of a vector of character with the amenities to be
geolocated (i.e. \code{c("pub", "restaurant")}). See Details or
\link{osm_amenities}.}

\item{limit}{maximum number of results to return per input address. Note
that each query returns a maximum of 50 results.}

\item{full_results}{returns all data from the geocoder service if TRUE.
If FALSE then only longitude and latitude are returned from the geocoder service.}

\item{return_addresses}{return input addresses with results if TRUE. Note that
most services return the input addresses with \code{full_results = TRUE} and setting
return_addresses to FALSE does not prevent this.}

\item{verbose}{if TRUE then detailed logs are output to the console}

\item{custom_query}{API-specific parameters to be used.
See \code{\link[=geo_lite]{geo_lite()}}.}

\item{points_only}{Logical \code{TRUE/FALSE}. Whether to return only spatial points (\code{TRUE}, which is the default) or potentially other shapes as provided by the Nominatim API (\code{FALSE}).}

\item{strict}{Logical TRUE/FALSE. Force the results to be included inside
the \code{bbox}. Note that Nominatim default behaviour may return results located
outside the provided bounding box.}
}
\value{
A \code{sf} object with the results.
}
\description{
This function search amenities as defined by OpenStreetMap on a restricted
area defined by
a bounding box in the form of (<min_latitude>, <min_longitude>,
<max_latitude>, <max_longitude>).
}
\details{
Bounding boxes can be located using different online tools, as
\href{https://boundingbox.klokantech.com/}{Bounding Box Tool}.

For a full list of valid amenities see
\url{https://wiki.openstreetmap.org/wiki/Key:amenity}.
}
\examples{
\donttest{
# Madrid, Spain

library(ggplot2)

bbox <- c(
  -3.888954, 40.311977,
  -3.517916, 40.643729
)

# Restaurants and pubs

rest_pub <- geo_amenity_sf(bbox,
  c("restaurant", "pub"),
  limit = 50
)


ggplot(rest_pub) +
  geom_sf()

# Hospital as polygon

hosp <- geo_amenity_sf(bbox,
  "hospital",
  points_only = FALSE
)

ggplot(hosp) +
  geom_sf()
}
}
\seealso{
Other spatial: 
\code{\link{bbox_to_poly}()},
\code{\link{geo_address_lookup_sf}()},
\code{\link{geo_lite_sf}()},
\code{\link{reverse_geo_lite_sf}()}

Other amenity: 
\code{\link{bbox_to_poly}()},
\code{\link{geo_amenity}()},
\code{\link{osm_amenities}}
}
\concept{amenity}
\concept{spatial}
