% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ve.R
\name{ve}
\alias{ve}
\title{Variable Entropy (VE) Measure}
\usage{
ve(data)
}
\arguments{
\item{data}{A \emph{data.frame} or a \emph{matrix} with cases in rows and variables in colums.}
}
\value{
The function returns a dissimilarity matrix of the size \code{n x n}, where \code{n} is the number of objects in the original dataset in the argument \code{data}.
\cr
}
\description{
A function for calculation of a proximity (dissimilarity) matrix based on the VE similarity measure.
}
\details{
The Variable Entropy similarity measure was introduced in (Sulc and Rezankova, 2019). It treats
the similarity between two categories based on the within-cluster variability expressed by the normalized entropy.
The measure assigns higher weights to rare categories.
}
\examples{
# sample data
data(data20)

# dissimilarity matrix calculation
prox.ve <- ve(data20)

}
\references{
Boriah S., Chandola V., Kumar V. (2008). Similarity measures for categorical data: A comparative evaluation.
In: Proceedings of the 8th SIAM International Conference on Data Mining, SIAM, p. 243-254.
 \cr
 \cr
Sulc Z. and Rezankova H. (2019). Comparison of Similarity Measures for Categorical Data in Hierarchical Clustering. Journal of Classification. 2019, 35(1), p. 58-72. DOI: 10.1007/s00357-019-09317-5.
}
\seealso{
\code{\link[nomclust]{eskin}},
\code{\link[nomclust]{good1}},
\code{\link[nomclust]{good2}},
\code{\link[nomclust]{good3}},
\code{\link[nomclust]{good4}},
\code{\link[nomclust]{iof}},
\code{\link[nomclust]{lin}},
\code{\link[nomclust]{lin1}},
\code{\link[nomclust]{morlini}}, 
\code{\link[nomclust]{of}},
\code{\link[nomclust]{sm}},
\code{\link[nomclust]{vm}}.
}
\author{
Zdenek Sulc. \cr Contact: \email{zdenek.sulc@vse.cz}
}
