% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/denominator.R
\name{denominator}
\alias{denominator}
\alias{nom_denom}
\title{Convert numbers to ordinal character vectors}
\usage{
denominator(
  x,
  numerator = 1,
  quarter = getOption("nombre.quarter", TRUE),
  negative = getOption("nombre.negative", "negative")
)

nom_denom(
  x,
  numerator = 1,
  quarter = getOption("nombre.quarter", TRUE),
  negative = getOption("nombre.negative", "negative")
)
}
\arguments{
\item{x}{A numeric vector}

\item{numerator}{A numeric vector.
The numerator(s) associated with the denominator(s).
When \code{numerator} is \code{1} or \code{-1}, returns a singular denominator.
When \code{numerator} is not \code{1} or \code{-1}, returns a plural denominator.}

\item{quarter}{A logical of length one.
If \code{TRUE}, the denominator of \code{4} will be "quarter(s)".
If \code{FALSE}, the denominator of \code{4} will be "fourth(s)".
Defaults to \code{TRUE}.
Default can be changed by setting \code{options("nombre.quarter")}.}

\item{negative}{A character of length one to append to negative numbers.
Defaults to \code{"negative"}.
Default can be changed by setting \code{options("nombre.negative")}.}
}
\value{
A character vector of the same length as \code{x}
}
\description{
Convert numbers to ordinal character vectors
}
\examples{
nom_denom(2)
nom_denom(1:10)
nom_denom(1:10, numerator = 2)
nom_denom(1:10, numerator = 1:10)

nom_denom(4)
nom_denom(4, quarter = FALSE)
}
