% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_unlinked_explicit.R
\name{sim_unlinked_explicit}
\alias{sim_unlinked_explicit}
\title{Simulate a sequence assuming node substitutions are not shared amongst
offspring, using the explicit simulation method (e.g. reverse substitutions
are modeled explicitly)}
\usage{
sim_unlinked_explicit(
  phy,
  Q1 = rep(1, 6),
  Q2 = rep(1, 6),
  rate1 = 0.1,
  rate2 = 0.1,
  l = 1000,
  bf = rep(0.25, 4),
  rootseq = NULL,
  node_time = 0.001
)
}
\arguments{
\item{phy}{phylogenetic tree for which to simulate sequences}

\item{Q1}{substitution matrix along the branches, default = JC}

\item{Q2}{substitution matrix on the nodes, default = JC}

\item{rate1}{mutation rate along the branch, default = 0.1}

\item{rate2}{mutation rate on the node, default = 0.1}

\item{l}{number of base pairs to simulate}

\item{bf}{base frequencies, default = c(0.25, 0.25, 0.25, 0.25)}

\item{rootseq}{sequence at the root, simulated by default}

\item{node_time}{amount of time spent at the nodes}
}
\value{
list with four items \enumerate{
\item{alignment} Phydat object with the resulting alignment
\item{rootseq} the rootsequence used
\item{total_branch_substitutions} total number of substitutions accumulated
on the branches
\item{total_node_substitutions} total number of substitutions accumulated at
the nodes}
}
\description{
Simulate a sequence assuming node substitutions are not shared amongst
offspring, using the explicit simulation method (e.g. reverse substitutions
are modeled explicitly)
}
