% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src_mongo.R
\name{src_mongo}
\alias{src_mongo}
\title{Setup a MongoDB database connection}
\usage{
src_mongo(collection = "test", db = "test", url = "mongodb://localhost", ...)
}
\arguments{
\item{collection}{(character) Name of collection}

\item{db}{(character) Name of database}

\item{url}{(character) Address of the MongoDB server in Mongo connection
string URI format, see to \code{\link[mongolite:mongo]{mongolite::mongo()}}}

\item{...}{Additional named parameters passed on to \code{\link[mongolite:mongo]{mongolite::mongo()}}}
}
\value{
A \code{nodbi} source object
}
\description{
Setup a MongoDB database connection
}
\details{
Uses \pkg{monoglite} as backend. \pkg{nodbi} creates or uses
a MongoDB collection, in which \code{nodbi} creates JSON documents.
If documents do not have root-level \verb{_id}'s, UUID's are created as \verb{_id}'s.
MongoDB but none of the other databases require to specify the container
already in the \code{src_mongo()} function.
For a benchmark, see \url{https://github.com/ropensci/nodbi#benchmark}
}
\examples{
\dontrun{
con <- src_mongo()
print(con)
}
}
