% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_coops_stations.R
\name{list_coops_stations}
\alias{list_coops_stations}
\title{Find All NOAA Stations}
\usage{
list_coops_stations()
}
\value{
A data frame.
}
\description{
This function produces a data frame with all NOAA stations.  The list of
stations is retrieved  from
\href{https://opendap.co-ops.nos.noaa.gov/stations/stationsXML.jsp}{NOAA's}
website when the function is called.
}
\details{
In the returned data frame there is one row for each station. The name,
location and date that the station was established are included as columns.
In addition, there are columns that provide the status of various sensors at
the station is included.  The column names indicate the type of sensor

In the status columns a value of \emph{1} indicates that sensor is working
A \emph{0} indicates that the sensor is not working.  If a particular
station does not have the capability indicated by the column name, the value
provided is \code{NA}
}
\examples{
# Do Not Run
\donttest{
station_df <- list_coops_stations()
}
}
