% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.net.R
\name{plot.elm}
\alias{plot.elm}
\title{Plot ELM network.}
\usage{
\method{plot}{elm}(x, r = 1, ...)
}
\arguments{
\item{x}{ELM network object, produced using \code{\link{elm}}.}

\item{r}{Ensemple member to plot.}

\item{...}{Unused argument.}
}
\value{
None. Function produces a plot.
}
\description{
Produces a plot of the ELM network architecture.
}
\note{
Neurons are coloured with \code{"lightgrey"}. Seasonal dummies are coloured with \code{"lightpink"} and xreg with \code{"lightblue"}.
}
\examples{
\dontshow{
 fit <- elm(AirPassengers,reps=1)
 plot(fit)
}
\dontrun{
 fit <- elm(AirPassengers)
 print(fit)
 plot(fit)
 frc <- forecast(fit,h=36)
 plot(frc)
}

}
\seealso{
\code{\link{elm}}, \code{\link{mlp}}.
}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}
}
\keyword{elm}
\keyword{thief}
\keyword{ts}
