% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlsic.R
\name{lsi}
\alias{lsi}
\title{Linear Least Squares with Inequality constraints (LSI)}
\usage{
lsi(a, b, u = NULL, co = NULL, rcond = 1e+10, mnorm = NULL, x0 = NULL)
}
\arguments{
\item{a}{dense matrix A or its QR decomposition}

\item{b}{right hand side vector}

\item{u}{dense matrix of inequality constraints}

\item{co}{right hand side vector of inequality constraints}

\item{rcond}{maximal condition number for determining rank deficient matrix}

\item{mnorm}{dummy parameter}

\item{x0}{dummy parameter}
}
\value{
solution vector whose attribute 'mes' may contain a message about possible numerical problems
}
\description{
solve linear least square problem (min ||A\%\emph{\%x-b||)
with inequality constraints \code{u\%}\%x>=co}
}
\details{
Method:
\enumerate{
\item reduce the problem to ldp (min(xat*xa) => least distance programming)
\item solve ldp
\item change back to x
}

mnrom, and x0 are dummy parameters which are here to make lsi()
compatible with lsi_ln() argument list
}
\seealso{
\link{lsi_ln}, \link{ldp}, \link[base:qr]{base::qr}
}
