% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMGM.R
\name{getMGM}
\alias{getMGM}
\title{Fit a Multivariate Latent Growth Curve Model or Multivariate Latent Change Score Model}
\usage{
getMGM(
  dat,
  t_var,
  y_var,
  curveFun,
  intrinsic = TRUE,
  records,
  y_model,
  starts = NULL,
  res_scale = NULL,
  res_cor = NULL,
  tries = NULL,
  OKStatus = 0,
  jitterD = "runif",
  loc = 1,
  scale = 0.25,
  paramOut = FALSE,
  names = NULL
)
}
\arguments{
\item{dat}{A wide-format data frame, with each row corresponding to a unique ID. It contains the observed variables
with repeated measurements and occasions for multiple longitudinal outcomes.}

\item{t_var}{A vector of strings, with each element representing the prefix for column names related to the time
variable for the corresponding outcome variable at each study wave.}

\item{y_var}{A vector of strings, with each element representing the prefix for column names corresponding to a
particular outcome variable at each study wave.}

\item{curveFun}{A string specifying the functional forms of the growth curve(s). Supported options for \code{y_model = "LGCM"} include:
\code{"linear"} (or \code{"LIN"}), \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"}
(or \code{"EXP"}), \code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"bilinear spline"} (or \code{"BLS"}). Supported options for
\code{y_model = "LCSM"} include: \code{"nonparametric"} (or \code{"NonP"}), \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"} (or \code{"EXP"}),
and \code{"Jenss-Bayley"} (or \code{"JB"}).}

\item{intrinsic}{A logical flag indicating whether to build an intrinsically nonlinear longitudinal model. Default is
\code{TRUE}.}

\item{records}{A list of numeric vectors, with each vector specifying the indices of the observed study waves for
the corresponding outcome variable.}

\item{y_model}{A string specifying how to fit the longitudinal outcome. Supported values are \code{"LGCM"} and \code{"LCSM"}.}

\item{starts}{A list containing initial values for the parameters. Default is \code{NULL}, indicating no user-specified initial
values.}

\item{res_scale}{A numeric vector with each element representing the scaling factor for the initial calculation of the residual
variance. These values should be between \code{0} and \code{1}, exclusive. By default, this is \code{NULL}, as it is unnecessary
when the user specifies the initial values using the \code{starts} argument.}

\item{res_cor}{A numeric value or vector for user-specified residual correlation between any two longitudinal outcomes to calculate
the corresponding initial value. By default, this is \code{NULL}, as it is unnecessary when the user specifies the initial values
using the \code{starts} argument.}

\item{tries}{An integer specifying the number of additional optimization attempts. Default is \code{NULL}.}

\item{OKStatus}{An integer (vector) specifying acceptable status codes for convergence. Default is \code{0}.}

\item{jitterD}{A string specifying the distribution for jitter. Supported values are: \code{"runif"} (uniform
distribution), \code{"rnorm"} (normal distribution), and \code{"rcauchy"} (Cauchy distribution). Default is \code{"runif"}.}

\item{loc}{A numeric value representing the location parameter of the jitter distribution. Default is \code{1}.}

\item{scale}{A numeric value representing the scale parameter of the jitter distribution. Default is \code{0.25}.}

\item{paramOut}{A logical flag indicating whether to output the parameter estimates and standard errors. Default is \code{FALSE}.}

\item{names}{A character vector specifying parameter names. Default is \code{NULL}.}
}
\value{
A list containing the fitted model and, if \code{paramOut = TRUE}, a data frame with parameter estimates and standard errors.
}
\description{
This function fits a multivariate latent growth curve model or a multivariate latent change score model
with the provided data. It manages model setup, optimization, and if requested, outputs parameter estimates and
standard errors.
}
\examples{
OpenMx::mxOption(model = NULL, key = "Default optimizer", "CSOLNP", reset = FALSE)
# Load ECLS-K (2011) data
data("RMS_dat")
RMS_dat0 <- RMS_dat
# Re-baseline the data so that the estimated initial status is for the starting point of the study
baseT <- RMS_dat0$T1
RMS_dat0$T1 <- RMS_dat0$T1 - baseT
RMS_dat0$T2 <- RMS_dat0$T2 - baseT
RMS_dat0$T3 <- RMS_dat0$T3 - baseT
RMS_dat0$T4 <- RMS_dat0$T4 - baseT
RMS_dat0$T5 <- RMS_dat0$T5 - baseT
RMS_dat0$T6 <- RMS_dat0$T6 - baseT
RMS_dat0$T7 <- RMS_dat0$T7 - baseT
RMS_dat0$T8 <- RMS_dat0$T8 - baseT
RMS_dat0$T9 <- RMS_dat0$T9 - baseT
\donttest{
# Fit linear multivariate latent growth curve model
LIN_PLGCM_f <- getMGM(
  dat = RMS_dat0, t_var = c("T", "T"), y_var = c("R", "M"), curveFun = "LIN",
  intrinsic = FALSE, records = list(1:9, 1:9), y_model = "LGCM", res_scale = c(0.1, 0.1),
  res_cor = 0.3
  )
# Fit bilinear spline multivariate latent growth curve model (random knots)
## Define parameter names
paraBLS_PLGCM.f <- c(
  "Y_mueta0", "Y_mueta1", "Y_mueta2", "Y_knot",
  paste0("Y_psi", c("00", "01", "02", "0g", "11", "12", "1g", "22", "2g", "gg")), "Y_res",
  "Z_mueta0", "Z_mueta1", "Z_mueta2", "Z_knot",
  paste0("Z_psi", c("00", "01", "02", "0g", "11", "12", "1g", "22", "2g", "gg")), "Z_res",
  paste0("YZ_psi", c(c("00", "10", "20", "g0", "01", "11", "21", "g1",
                       "02", "12", "22", "g2", "0g", "1g", "2g", "gg"))),"YZ_res"
  )
## Fit model
BLS_PLGCM_f <- getMGM(
  dat = RMS_dat0, t_var = c("T", "T"), y_var = c("R", "M"), curveFun = "BLS", intrinsic = TRUE,
  records = list(1:9, 1:9), y_model = "LGCM", res_scale = c(0.1, 0.1), res_cor = 0.3,
  paramOut = TRUE, names = paraBLS_PLGCM.f
  )
BLS_PLGCM_f[[2]]
}

}
\references{
\itemize{
  \item {Liu, J., & Perera, R. A. (2021). "Estimating Knots and Their Association in Parallel Bilinear Spline Growth Curve Models in
  the Framework of Individual Measurement Occasions," Psychological Methods (Advance online publication).
  \doi{10.1037/met0000309}}
  \item {Blozis, S. A. (2004). "Structured Latent Curve Models for the Study of Change in Multivariate Repeated Measures," Psychological
  Methods, 9(3), 334-353. \doi{10.1037/1082-989X.9.3.334}}
}
}
