% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc_functions.R
\name{.make_long_data}
\alias{.make_long_data}
\title{Worker function to make long form data set needed for
CVTMLE targeting step}
\usage{
.make_long_data(
  x,
  gn,
  update = FALSE,
  epsilon_0 = 0,
  epsilon_1 = 0,
  tol = 0.001
)
}
\arguments{
\item{x}{An entry in the "predictions list" that has certain
named values (see \code{?.get_predictions})}

\item{gn}{An estimate of the probability that \code{Y = 1}.}

\item{update}{A boolean of whether this is called for initial
construction of the long data set or as part of the targeting loop. 
If the former, empirical "density" estimates are used. If the latter
these are derived from the targeted cdf.}

\item{epsilon_0}{If \code{update = TRUE}, a vector of TMLE fluctuation
parameter estimates used to add the CDF and PDF of Psi(X) to the data set.}

\item{epsilon_1}{Same as for \code{epsilon_0}.}

\item{tol}{A truncation level when taking logit transformations.}
}
\value{
A long form data list of a particular set up. Columns are named id 
(multiple rows per observation in validation sample), 
u (if Yi = 0, these are the values of psi(x) in the
training sample for obs with Y = 1, if Yi = 1, these are values of psi(x) in
the training sample for obs. with Y = 0), 
Yi (this observation's value of Y), Fn (estimated value of the cdf of psi(X) 
given Y = Yi in the training sample), 
dFn (estimated value of the density of psi(X) given Y = (1-Yi) in the 
training sample), psi (the value of this observations Psihat(P_{n,B_n}^0)),
gn (estimate of marginal of Y e.g., computed in whole sample), outcome (indicator
that psix <= u), logit_Fn (the cdf estimate on the logit scale, needed for 
offset in targeting model).
}
\description{
Worker function to make long form data set needed for
CVTMLE targeting step
}
