% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlminb.R
\name{nlminbControl}
\alias{nlminbControl}
\title{nlmixr2 nlminb defaults}
\usage{
nlminbControl(
  eval.max = 200,
  iter.max = 150,
  trace = 0,
  abs.tol = 0,
  rel.tol = 1e-10,
  x.tol = 1.5e-08,
  xf.tol = 2.2e-14,
  step.min = 1,
  step.max = 1,
  sing.tol = rel.tol,
  scale = 1,
  scale.init = NULL,
  diff.g = NULL,
  rxControl = NULL,
  optExpression = TRUE,
  sumProd = FALSE,
  returnNlminb = FALSE,
  solveType = c("hessian", "grad", "fun"),
  stickyRecalcN = 4,
  maxOdeRecalc = 5,
  odeRecalcFactor = 10^(0.5),
  eventType = c("central", "forward"),
  shiErr = (.Machine$double.eps)^(1/3),
  shi21maxFD = 20L,
  optimHessType = c("central", "forward"),
  hessErr = (.Machine$double.eps)^(1/3),
  shi21maxHess = 20L,
  useColor = crayon::has_color(),
  printNcol = floor((getOption("width") - 23)/12),
  print = 1L,
  normType = c("rescale2", "mean", "rescale", "std", "len", "constant"),
  scaleType = c("nlmixr2", "norm", "mult", "multAdd"),
  scaleCmax = 1e+05,
  scaleCmin = 1e-05,
  scaleC = NULL,
  scaleTo = 1,
  gradTo = 1,
  addProp = c("combined2", "combined1"),
  calcTables = TRUE,
  compress = TRUE,
  covMethod = c("r", "nlminb", ""),
  adjObf = TRUE,
  ci = 0.95,
  sigdig = 4,
  sigdigTable = NULL,
  ...
)
}
\arguments{
\item{eval.max}{Maximum number of evaluations of the objective
function allowed.  Defaults to 200.}

\item{iter.max}{Maximum number of iterations allowed.  Defaults to
150.}

\item{trace}{The value of the objective function and the parameters
is printed every trace'th iteration.  When 0 no trace information
is to be printed}

\item{abs.tol}{Absolute tolerance.  Defaults to 0 so the absolute
convergence test is not used.  If the objective function is known
to be non-negative, the previous default of `1e-20` would be more
appropriate}

\item{rel.tol}{Relative tolerance.  Defaults to `1e-10`.}

\item{x.tol}{X tolerance.  Defaults to `1.5e-8`.}

\item{xf.tol}{false convergence tolerance.  Defaults to `2.2e-14`.}

\item{step.min}{Minimum step size.  Default to ‘1.’.}

\item{step.max}{Maximum step size.  Default to ‘1.’.}

\item{sing.tol}{singular convergence tolerance; defaults to `rel.tol;.}

\item{scale}{See PORT documentation (or leave alone).}

\item{scale.init}{... probably need to check PORT documentation}

\item{diff.g}{an estimated bound on the relative error in the
objective function value}

\item{rxControl}{`rxode2` ODE solving options during fitting, created with `rxControl()`}

\item{optExpression}{Optimize the rxode2 expression to speed up
calculation. By default this is turned on.}

\item{sumProd}{Is a boolean indicating if the model should change
multiplication to high precision multiplication and sums to
high precision sums using the PreciseSums package.  By default
this is \code{FALSE}.}

\item{returnNlminb}{logical; when TRUE this will return the nlminb
result instead of the nlmixr2 fit object}

\item{solveType}{tells if `nlm` will use nlmixr2's analytical
  gradients when available (finite differences will be used for
  event-related parameters like parameters controlling lag time,
  duration/rate of infusion, and modeled bioavailability). This can
  be:

 - `"hessian"` which will use the analytical gradients to create a
    Hessian with finite differences.

- `"gradient"` which will use the gradient and let `nlm` calculate
   the finite difference hessian

- `"fun"` where nlm will calculate both the finite difference
   gradient and the finite difference Hessian

 When using nlmixr2's finite differences, the "ideal" step size for
 either central or forward differences are optimized for with the
 Shi2021 method which may give more accurate derivatives}

\item{stickyRecalcN}{The number of bad ODE solves before reducing
the atol/rtol for the rest of the problem.}

\item{maxOdeRecalc}{Maximum number of times to reduce the ODE
tolerances and try to resolve the system if there was a bad
ODE solve.}

\item{odeRecalcFactor}{The ODE recalculation factor when ODE
solving goes bad, this is the factor the rtol/atol is reduced}

\item{eventType}{Event gradient type for dosing events; Can be
"central" or "forward"}

\item{shiErr}{This represents the epsilon when optimizing the ideal
step size for numeric differentiation using the Shi2021 method}

\item{shi21maxFD}{The maximum number of steps for the optimization
of the forward difference step size when using dosing events (lag
time, modeled duration/rate and bioavailability)}

\item{optimHessType}{The hessian type for when calculating the
individual hessian by numeric differences (in generalized
log-likelihood estimation).  The options are "central", and
"forward".  The central differences is what R's `optimHess()`
uses and is the default for this method. (Though the "forward" is
faster and still reasonable for most cases).  The Shi21 cannot be
changed for the Gill83 algorithm with the optimHess in a
generalized likelihood problem.}

\item{hessErr}{This represents the epsilon when optimizing the
Hessian step size using the Shi2021 method.}

\item{shi21maxHess}{Maximum number of times to optimize the best
step size for the hessian calculation}

\item{useColor}{Boolean indicating if focei can use ASCII color codes}

\item{printNcol}{Number of columns to printout before wrapping
parameter estimates/gradient}

\item{print}{Integer representing when the outer step is
printed. When this is 0 or do not print the iterations.  1 is
print every function evaluation (default), 5 is print every 5
evaluations.}

\item{normType}{This is the type of parameter
    normalization/scaling used to get the scaled initial values
    for nlmixr2.  These are used with \code{scaleType} of.

    With the exception of \code{rescale2}, these come
    from
    \href{https://en.wikipedia.org/wiki/Feature_scaling}{Feature
    Scaling}. The \code{rescale2} The rescaling is the same type
    described in the
    \href{http://apmonitor.com/me575/uploads/Main/optimization_book.pdf}{OptdesX}
    software manual.

    In general, all all scaling formula can be described by:

    \deqn{v_{scaled}}{Vscaled} = (\deqn{v_{unscaled}-C_{1}}{Vunscaled-C1})/\deqn{C_{2}}{C2}


    Where


    The other data normalization approaches follow the following formula

    \deqn{v_{scaled}}{Vscaled} = (\deqn{v_{unscaled}-C_{1}}{Vunscaled-C1})/\deqn{C_{2}}{C2}

\itemize{

\item \code{rescale2} This scales all parameters from (-1 to 1).
    The relative differences between the parameters are preserved
    with this approach and the constants are:

    \deqn{C_{1}}{C1} = (max(all unscaled values)+min(all unscaled values))/2

    \deqn{C_{2}}{C2} = (max(all unscaled values) - min(all unscaled values))/2


\item \code{rescale} or min-max normalization. This rescales all
    parameters from (0 to 1).  As in the \code{rescale2} the
    relative differences are preserved.  In this approach:

    \deqn{C_{1}}{C1} = min(all unscaled values)

    \deqn{C_{2}}{C2} = max(all unscaled values) - min(all unscaled values)


\item \code{mean} or mean normalization.  This rescales to center
    the parameters around the mean but the parameters are from 0
    to 1.  In this approach:

    \deqn{C_{1}}{C1} = mean(all unscaled values)

    \deqn{C_{2}}{C2} = max(all unscaled values) - min(all unscaled values)

\item \code{std} or standardization.  This standardizes by the mean
     and standard deviation.  In this approach:

    \deqn{C_{1}}{C1} = mean(all unscaled values)

    \deqn{C_{2}}{C2} = sd(all unscaled values)

\item \code{len} or unit length scaling.  This scales the
   parameters to the unit length.  For this approach we use the Euclidean length, that
   is:

    \deqn{C_{1}}{C1} = 0

    \deqn{C_{2}}{C2} = \deqn{\sqrt(v_1^2 + v_2^2 + \cdots + v_n^2)}{sqrt(v_1^2 + v_2^2 + ... + v_n^2)}


\item \code{constant} which does not perform data normalization. That is

    \deqn{C_{1}}{C1} = 0

    \deqn{C_{2}}{C2} = 1

}}

\item{scaleType}{The scaling scheme for nlmixr2.  The supported types are:

\itemize{
\item \code{nlmixr2}  In this approach the scaling is performed by the following equation:

   \deqn{v_{scaled}}{Vscaled} = (\deqn{v_{current} - v_{init}}{Vcurrent - Vinit})*scaleC[i] + scaleTo

The \code{scaleTo} parameter is specified by the \code{normType},
and the scales are specified by \code{scaleC}.

\item \code{norm} This approach uses the simple scaling provided
    by the \code{normType} argument.

\item \code{mult} This approach does not use the data
normalization provided by \code{normType}, but rather uses
multiplicative scaling to a constant provided by the \code{scaleTo}
argument.

  In this case:

  \deqn{v_{scaled}}{Vscaled} = \deqn{v_{current}}{Vcurrent}/\deqn{v_{init}}{Vinit}*scaleTo

\item \code{multAdd} This approach changes the scaling based on
the parameter being specified.  If a parameter is defined in an
exponential block (ie exp(theta)), then it is scaled on a
linearly, that is:

  \deqn{v_{scaled}}{Vscaled} = (\deqn{v_{current}-v_{init}}{Vcurrent-Vinit}) + scaleTo

Otherwise the parameter is scaled multiplicatively.

   \deqn{v_{scaled}}{Vscaled} = \deqn{v_{current}}{Vcurrent}/\deqn{v_{init}}{Vinit}*scaleTo

}}

\item{scaleCmax}{Maximum value of the scaleC to prevent overflow.}

\item{scaleCmin}{Minimum value of the scaleC to prevent underflow.}

\item{scaleC}{The scaling constant used with
    \code{scaleType=nlmixr2}.  When not specified, it is based on
    the type of parameter that is estimated.  The idea is to keep
    the derivatives similar on a log scale to have similar
    gradient sizes.  Hence parameters like log(exp(theta)) would
    have a scaling factor of 1 and log(theta) would have a scaling
    factor of ini_value (to scale by 1/value; ie
    d/dt(log(ini_value)) = 1/ini_value or scaleC=ini_value)

   \itemize{

   \item For parameters in an exponential (ie exp(theta)) or
   parameters specifying powers, boxCox or yeoJohnson
   transformations , this is 1.

   \item For additive, proportional, lognormal error structures,
   these are given by 0.5*abs(initial_estimate)

   \item Factorials are scaled by abs(1/digamma(initial_estimate+1))

   \item parameters in a log scale (ie log(theta)) are transformed
   by log(abs(initial_estimate))*abs(initial_estimate)

   }

   These parameter scaling coefficients are chose to try to keep
   similar slopes among parameters.  That is they all follow the
   slopes approximately on a log-scale.

   While these are chosen in a logical manner, they may not always
   apply.  You can specify each parameters scaling factor by this
   parameter if you wish.}

\item{scaleTo}{Scale the initial parameter estimate to this value.
By default this is 1.  When zero or below, no scaling is performed.}

\item{gradTo}{this is the factor that the gradient is scaled to
before optimizing.  This only works with
scaleType="nlmixr2".}

\item{addProp}{specifies the type of additive plus proportional
  errors, the one where standard deviations add (combined1) or the
  type where the variances add (combined2).

The combined1 error type can be described by the following equation:

  \deqn{y = f + (a + b\times f^c) \times \varepsilon}{y = f + (a + b*f^c)*err}

The combined2 error model can be described by the following equation:

 \deqn{y = f + \sqrt{a^2 + b^2\times f^{2\times c}} \times \varepsilon}{y = f + sqrt(a^2 + b^2*(f^c)^2)*err}

 Where:

 - y represents the observed value

 - f represents the predicted value

 - a  is the additive standard deviation

 - b is the proportional/power standard deviation

 - c is the power exponent (in the proportional case c=1)}

\item{calcTables}{This boolean is to determine if the foceiFit
will calculate tables. By default this is \code{TRUE}}

\item{compress}{Should the object have compressed items}

\item{covMethod}{Method for calculating covariance.  In this
    discussion, R is the Hessian matrix of the objective
    function. The S matrix is the sum of individual
    gradient cross-product (evaluated at the individual empirical
    Bayes estimates).

\itemize{

 \item "\code{r,s}" Uses the sandwich matrix to calculate the
 covariance, that is: \code{solve(R) \%*\% S \%*\% solve(R)}

 \item "\code{r}" Uses the Hessian matrix to calculate the
 covariance as \code{2 \%*\% solve(R)}

 \item "\code{s}" Uses the cross-product matrix to calculate the
 covariance as \code{4 \%*\% solve(S)}

 \item "" Does not calculate the covariance step.
}}

\item{adjObf}{is a boolean to indicate if the objective function
should be adjusted to be closer to NONMEM's default objective
function.  By default this is \code{TRUE}}

\item{ci}{Confidence level for some tables.  By default this is
0.95 or 95\% confidence.}

\item{sigdig}{Optimization significant digits. This controls:

\itemize{

 \item The tolerance of the inner and outer optimization is \code{10^-sigdig}

 \item The tolerance of the ODE solvers is
 \code{0.5*10^(-sigdig-2)}; For the sensitivity equations and
 steady-state solutions the default is \code{0.5*10^(-sigdig-1.5)}
 (sensitivity changes only applicable for liblsoda)

 \item The tolerance of the boundary check is \code{5 * 10 ^ (-sigdig + 1)}

}}

\item{sigdigTable}{Significant digits in the final output table.
If not specified, then it matches the significant digits in the
`sigdig` optimization algorithm.  If `sigdig` is NULL, use 3.}

\item{...}{Further arguments to be supplied to \code{objective}.}
}
\description{
nlmixr2 nlminb defaults
}
\examples{
\donttest{
# A logit regression example with emax model

dsn <- data.frame(i=1:1000)
dsn$time <- exp(rnorm(1000))
dsn$DV=rbinom(1000,1,exp(-1+dsn$time)/(1+exp(-1+dsn$time)))

mod <- function() {
 ini({
   E0 <- 0.5
   Em <- 0.5
   E50 <- 2
   g <- fix(2)
 })
 model({
   v <- E0+Em*time^g/(E50^g+time^g)
   ll(bin) ~ DV * v - log(1 + exp(v))
 })
}

fit2 <- nlmixr(mod, dsn, est="nlminb")

print(fit2)

# you can also get the nlm output with fit2$nlminb

fit2$nlminb
}
}
\author{
Matthew L. Fidler
}
