% $Id: initialize.corStruct.Rd,v 1.7 2002/03/05 14:59:39 bates Exp $
\name{Initialize.corStruct}
\title{Initialize corStruct Object}
\usage{
\method{Initialize}{corStruct}(object, data, \dots)
}
\alias{Initialize.corStruct}
\alias{Initialize.corAR1}
\alias{Initialize.corARMA}
\alias{Initialize.corCAR1}
\alias{Initialize.corCompSymm}
\alias{Initialize.corHF}
\alias{Initialize.corIdent}
\alias{Initialize.corLin}
\alias{Initialize.corNatural}
\alias{Initialize.corSpatial}
\alias{Initialize.corSpher}
\alias{Initialize.corSymm}
\arguments{
 \item{object}{an object inheriting from class \code{corStruct}
   representing a correlation structure.}
 \item{data}{a data frame in which to evaluate the variables defined in
   \code{formula(object)}.}
 \item{\dots}{this argument is included to make this method compatible
   with the generic.}
}
\description{
  This method initializes \code{object} by evaluating its associated
  covariate(s) and grouping factor, if any is present, in \code{data},
  calculating various dimensions and constants used by optimization
  algorithms involving \code{corStruct} objects (see the appropriate
  \code{Dim} method documentation), and assigning initial values for
  the coefficients in \code{object}, if none were present.
}
\value{
  an initialized object with the same class as \code{object}
  representing a correlation structure.
}
\author{Jose Pinheiro \email{Jose.Pinheiro@pharma.novartis.com} and Douglas Bates \email{bates@stat.wisc.edu}}

\seealso{\code{\link{Dim.corStruct}}}

\examples{
data(Orthodont)
cs1 <- corAR1(form = ~ 1 | Subject)
cs1 <- Initialize(cs1, data = Orthodont)
}
\keyword{models}
